/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type.code;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.System;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.String;

@System(value="http://terminology.hl7.org/CodeSystem/v3-Confidentiality")
public class DocumentConfidentiality
extends Code {
    public static final DocumentConfidentiality L = DocumentConfidentiality.builder().value(Value.L).build();
    public static final DocumentConfidentiality M = DocumentConfidentiality.builder().value(Value.M).build();
    public static final DocumentConfidentiality N = DocumentConfidentiality.builder().value(Value.N).build();
    public static final DocumentConfidentiality R = DocumentConfidentiality.builder().value(Value.R).build();
    public static final DocumentConfidentiality U = DocumentConfidentiality.builder().value(Value.U).build();
    public static final DocumentConfidentiality V = DocumentConfidentiality.builder().value(Value.V).build();
    private volatile int hashCode;

    private DocumentConfidentiality(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static DocumentConfidentiality of(Value value) {
        switch (value) {
            case L: {
                return L;
            }
            case M: {
                return M;
            }
            case N: {
                return N;
            }
            case R: {
                return R;
            }
            case U: {
                return U;
            }
            case V: {
                return V;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static DocumentConfidentiality of(java.lang.String value) {
        return DocumentConfidentiality.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return DocumentConfidentiality.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return DocumentConfidentiality.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DocumentConfidentiality other = (DocumentConfidentiality)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        L("L"),
        M("M"),
        N("N"),
        R("R"),
        U("U"),
        V("V");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "L": {
                    return L;
                }
                case "M": {
                    return M;
                }
                case "N": {
                    return N;
                }
                case "R": {
                    return R;
                }
                case "U": {
                    return U;
                }
                case "V": {
                    return V;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public DocumentConfidentiality build() {
            DocumentConfidentiality documentConfidentiality = new DocumentConfidentiality(this);
            if (this.validating) {
                this.validate(documentConfidentiality);
            }
            return documentConfidentiality;
        }

        protected void validate(DocumentConfidentiality documentConfidentiality) {
            super.validate(documentConfidentiality);
        }

        protected Builder from(DocumentConfidentiality documentConfidentiality) {
            super.from(documentConfidentiality);
            return this;
        }
    }
}

