/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type.code;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.System;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.String;

@System(value="http://hl7.org/fhir/endpoint-status")
public class EndpointStatus
extends Code {
    public static final EndpointStatus ACTIVE = EndpointStatus.builder().value(Value.ACTIVE).build();
    public static final EndpointStatus SUSPENDED = EndpointStatus.builder().value(Value.SUSPENDED).build();
    public static final EndpointStatus ERROR = EndpointStatus.builder().value(Value.ERROR).build();
    public static final EndpointStatus OFF = EndpointStatus.builder().value(Value.OFF).build();
    public static final EndpointStatus ENTERED_IN_ERROR = EndpointStatus.builder().value(Value.ENTERED_IN_ERROR).build();
    public static final EndpointStatus TEST = EndpointStatus.builder().value(Value.TEST).build();
    private volatile int hashCode;

    private EndpointStatus(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static EndpointStatus of(Value value) {
        switch (value) {
            case ACTIVE: {
                return ACTIVE;
            }
            case SUSPENDED: {
                return SUSPENDED;
            }
            case ERROR: {
                return ERROR;
            }
            case OFF: {
                return OFF;
            }
            case ENTERED_IN_ERROR: {
                return ENTERED_IN_ERROR;
            }
            case TEST: {
                return TEST;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static EndpointStatus of(java.lang.String value) {
        return EndpointStatus.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return EndpointStatus.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return EndpointStatus.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EndpointStatus other = (EndpointStatus)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        ACTIVE("active"),
        SUSPENDED("suspended"),
        ERROR("error"),
        OFF("off"),
        ENTERED_IN_ERROR("entered-in-error"),
        TEST("test");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "active": {
                    return ACTIVE;
                }
                case "suspended": {
                    return SUSPENDED;
                }
                case "error": {
                    return ERROR;
                }
                case "off": {
                    return OFF;
                }
                case "entered-in-error": {
                    return ENTERED_IN_ERROR;
                }
                case "test": {
                    return TEST;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public EndpointStatus build() {
            EndpointStatus endpointStatus = new EndpointStatus(this);
            if (this.validating) {
                this.validate(endpointStatus);
            }
            return endpointStatus;
        }

        protected void validate(EndpointStatus endpointStatus) {
            super.validate(endpointStatus);
        }

        protected Builder from(EndpointStatus endpointStatus) {
            super.from(endpointStatus);
            return this;
        }
    }
}

