/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type.code;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.System;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.String;

@System(value="http://hl7.org/fhir/examplescenario-actor-type")
public class ExampleScenarioActorType
extends Code {
    public static final ExampleScenarioActorType PERSON = ExampleScenarioActorType.builder().value(Value.PERSON).build();
    public static final ExampleScenarioActorType ENTITY = ExampleScenarioActorType.builder().value(Value.ENTITY).build();
    private volatile int hashCode;

    private ExampleScenarioActorType(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static ExampleScenarioActorType of(Value value) {
        switch (value) {
            case PERSON: {
                return PERSON;
            }
            case ENTITY: {
                return ENTITY;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static ExampleScenarioActorType of(java.lang.String value) {
        return ExampleScenarioActorType.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return ExampleScenarioActorType.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return ExampleScenarioActorType.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExampleScenarioActorType other = (ExampleScenarioActorType)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        PERSON("person"),
        ENTITY("entity");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "person": {
                    return PERSON;
                }
                case "entity": {
                    return ENTITY;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public ExampleScenarioActorType build() {
            ExampleScenarioActorType exampleScenarioActorType = new ExampleScenarioActorType(this);
            if (this.validating) {
                this.validate(exampleScenarioActorType);
            }
            return exampleScenarioActorType;
        }

        protected void validate(ExampleScenarioActorType exampleScenarioActorType) {
            super.validate(exampleScenarioActorType);
        }

        protected Builder from(ExampleScenarioActorType exampleScenarioActorType) {
            super.from(exampleScenarioActorType);
            return this;
        }
    }
}

