/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type.code;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.System;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.String;

@System(value="http://hl7.org/fhir/data-types")
public class FHIRDefinedType
extends Code {
    public static final FHIRDefinedType ADDRESS = FHIRDefinedType.builder().value(Value.ADDRESS).build();
    public static final FHIRDefinedType AGE = FHIRDefinedType.builder().value(Value.AGE).build();
    public static final FHIRDefinedType ANNOTATION = FHIRDefinedType.builder().value(Value.ANNOTATION).build();
    public static final FHIRDefinedType ATTACHMENT = FHIRDefinedType.builder().value(Value.ATTACHMENT).build();
    public static final FHIRDefinedType BACKBONE_ELEMENT = FHIRDefinedType.builder().value(Value.BACKBONE_ELEMENT).build();
    public static final FHIRDefinedType CODEABLE_CONCEPT = FHIRDefinedType.builder().value(Value.CODEABLE_CONCEPT).build();
    public static final FHIRDefinedType CODEABLE_REFERENCE = FHIRDefinedType.builder().value(Value.CODEABLE_REFERENCE).build();
    public static final FHIRDefinedType CODING = FHIRDefinedType.builder().value(Value.CODING).build();
    public static final FHIRDefinedType CONTACT_DETAIL = FHIRDefinedType.builder().value(Value.CONTACT_DETAIL).build();
    public static final FHIRDefinedType CONTACT_POINT = FHIRDefinedType.builder().value(Value.CONTACT_POINT).build();
    public static final FHIRDefinedType CONTRIBUTOR = FHIRDefinedType.builder().value(Value.CONTRIBUTOR).build();
    public static final FHIRDefinedType COUNT = FHIRDefinedType.builder().value(Value.COUNT).build();
    public static final FHIRDefinedType DATA_REQUIREMENT = FHIRDefinedType.builder().value(Value.DATA_REQUIREMENT).build();
    public static final FHIRDefinedType DISTANCE = FHIRDefinedType.builder().value(Value.DISTANCE).build();
    public static final FHIRDefinedType DOSAGE = FHIRDefinedType.builder().value(Value.DOSAGE).build();
    public static final FHIRDefinedType DURATION = FHIRDefinedType.builder().value(Value.DURATION).build();
    public static final FHIRDefinedType ELEMENT = FHIRDefinedType.builder().value(Value.ELEMENT).build();
    public static final FHIRDefinedType ELEMENT_DEFINITION = FHIRDefinedType.builder().value(Value.ELEMENT_DEFINITION).build();
    public static final FHIRDefinedType EXPRESSION = FHIRDefinedType.builder().value(Value.EXPRESSION).build();
    public static final FHIRDefinedType EXTENSION = FHIRDefinedType.builder().value(Value.EXTENSION).build();
    public static final FHIRDefinedType HUMAN_NAME = FHIRDefinedType.builder().value(Value.HUMAN_NAME).build();
    public static final FHIRDefinedType IDENTIFIER = FHIRDefinedType.builder().value(Value.IDENTIFIER).build();
    public static final FHIRDefinedType MARKETING_STATUS = FHIRDefinedType.builder().value(Value.MARKETING_STATUS).build();
    public static final FHIRDefinedType META = FHIRDefinedType.builder().value(Value.META).build();
    public static final FHIRDefinedType MONEY = FHIRDefinedType.builder().value(Value.MONEY).build();
    public static final FHIRDefinedType MONEY_QUANTITY = FHIRDefinedType.builder().value(Value.MONEY_QUANTITY).build();
    public static final FHIRDefinedType NARRATIVE = FHIRDefinedType.builder().value(Value.NARRATIVE).build();
    public static final FHIRDefinedType PARAMETER_DEFINITION = FHIRDefinedType.builder().value(Value.PARAMETER_DEFINITION).build();
    public static final FHIRDefinedType PERIOD = FHIRDefinedType.builder().value(Value.PERIOD).build();
    public static final FHIRDefinedType POPULATION = FHIRDefinedType.builder().value(Value.POPULATION).build();
    public static final FHIRDefinedType PROD_CHARACTERISTIC = FHIRDefinedType.builder().value(Value.PROD_CHARACTERISTIC).build();
    public static final FHIRDefinedType PRODUCT_SHELF_LIFE = FHIRDefinedType.builder().value(Value.PRODUCT_SHELF_LIFE).build();
    public static final FHIRDefinedType QUANTITY = FHIRDefinedType.builder().value(Value.QUANTITY).build();
    public static final FHIRDefinedType RANGE = FHIRDefinedType.builder().value(Value.RANGE).build();
    public static final FHIRDefinedType RATIO = FHIRDefinedType.builder().value(Value.RATIO).build();
    public static final FHIRDefinedType RATIO_RANGE = FHIRDefinedType.builder().value(Value.RATIO_RANGE).build();
    public static final FHIRDefinedType REFERENCE = FHIRDefinedType.builder().value(Value.REFERENCE).build();
    public static final FHIRDefinedType RELATED_ARTIFACT = FHIRDefinedType.builder().value(Value.RELATED_ARTIFACT).build();
    public static final FHIRDefinedType SAMPLED_DATA = FHIRDefinedType.builder().value(Value.SAMPLED_DATA).build();
    public static final FHIRDefinedType SIGNATURE = FHIRDefinedType.builder().value(Value.SIGNATURE).build();
    public static final FHIRDefinedType SIMPLE_QUANTITY = FHIRDefinedType.builder().value(Value.SIMPLE_QUANTITY).build();
    public static final FHIRDefinedType TIMING = FHIRDefinedType.builder().value(Value.TIMING).build();
    public static final FHIRDefinedType TRIGGER_DEFINITION = FHIRDefinedType.builder().value(Value.TRIGGER_DEFINITION).build();
    public static final FHIRDefinedType USAGE_CONTEXT = FHIRDefinedType.builder().value(Value.USAGE_CONTEXT).build();
    public static final FHIRDefinedType BASE64BINARY = FHIRDefinedType.builder().value(Value.BASE64BINARY).build();
    public static final FHIRDefinedType BOOLEAN = FHIRDefinedType.builder().value(Value.BOOLEAN).build();
    public static final FHIRDefinedType CANONICAL = FHIRDefinedType.builder().value(Value.CANONICAL).build();
    public static final FHIRDefinedType CODE = FHIRDefinedType.builder().value(Value.CODE).build();
    public static final FHIRDefinedType DATE = FHIRDefinedType.builder().value(Value.DATE).build();
    public static final FHIRDefinedType DATE_TIME = FHIRDefinedType.builder().value(Value.DATE_TIME).build();
    public static final FHIRDefinedType DECIMAL = FHIRDefinedType.builder().value(Value.DECIMAL).build();
    public static final FHIRDefinedType ID = FHIRDefinedType.builder().value(Value.ID).build();
    public static final FHIRDefinedType INSTANT = FHIRDefinedType.builder().value(Value.INSTANT).build();
    public static final FHIRDefinedType INTEGER = FHIRDefinedType.builder().value(Value.INTEGER).build();
    public static final FHIRDefinedType MARKDOWN = FHIRDefinedType.builder().value(Value.MARKDOWN).build();
    public static final FHIRDefinedType OID = FHIRDefinedType.builder().value(Value.OID).build();
    public static final FHIRDefinedType POSITIVE_INT = FHIRDefinedType.builder().value(Value.POSITIVE_INT).build();
    public static final FHIRDefinedType STRING = FHIRDefinedType.builder().value(Value.STRING).build();
    public static final FHIRDefinedType TIME = FHIRDefinedType.builder().value(Value.TIME).build();
    public static final FHIRDefinedType UNSIGNED_INT = FHIRDefinedType.builder().value(Value.UNSIGNED_INT).build();
    public static final FHIRDefinedType URI = FHIRDefinedType.builder().value(Value.URI).build();
    public static final FHIRDefinedType URL = FHIRDefinedType.builder().value(Value.URL).build();
    public static final FHIRDefinedType UUID = FHIRDefinedType.builder().value(Value.UUID).build();
    public static final FHIRDefinedType XHTML = FHIRDefinedType.builder().value(Value.XHTML).build();
    public static final FHIRDefinedType RESOURCE = FHIRDefinedType.builder().value(Value.RESOURCE).build();
    public static final FHIRDefinedType BINARY = FHIRDefinedType.builder().value(Value.BINARY).build();
    public static final FHIRDefinedType BUNDLE = FHIRDefinedType.builder().value(Value.BUNDLE).build();
    public static final FHIRDefinedType DOMAIN_RESOURCE = FHIRDefinedType.builder().value(Value.DOMAIN_RESOURCE).build();
    public static final FHIRDefinedType ACCOUNT = FHIRDefinedType.builder().value(Value.ACCOUNT).build();
    public static final FHIRDefinedType ACTIVITY_DEFINITION = FHIRDefinedType.builder().value(Value.ACTIVITY_DEFINITION).build();
    public static final FHIRDefinedType ADMINISTRABLE_PRODUCT_DEFINITION = FHIRDefinedType.builder().value(Value.ADMINISTRABLE_PRODUCT_DEFINITION).build();
    public static final FHIRDefinedType ADVERSE_EVENT = FHIRDefinedType.builder().value(Value.ADVERSE_EVENT).build();
    public static final FHIRDefinedType ALLERGY_INTOLERANCE = FHIRDefinedType.builder().value(Value.ALLERGY_INTOLERANCE).build();
    public static final FHIRDefinedType APPOINTMENT = FHIRDefinedType.builder().value(Value.APPOINTMENT).build();
    public static final FHIRDefinedType APPOINTMENT_RESPONSE = FHIRDefinedType.builder().value(Value.APPOINTMENT_RESPONSE).build();
    public static final FHIRDefinedType AUDIT_EVENT = FHIRDefinedType.builder().value(Value.AUDIT_EVENT).build();
    public static final FHIRDefinedType BASIC = FHIRDefinedType.builder().value(Value.BASIC).build();
    public static final FHIRDefinedType BIOLOGICALLY_DERIVED_PRODUCT = FHIRDefinedType.builder().value(Value.BIOLOGICALLY_DERIVED_PRODUCT).build();
    public static final FHIRDefinedType BODY_STRUCTURE = FHIRDefinedType.builder().value(Value.BODY_STRUCTURE).build();
    public static final FHIRDefinedType CAPABILITY_STATEMENT = FHIRDefinedType.builder().value(Value.CAPABILITY_STATEMENT).build();
    public static final FHIRDefinedType CARE_PLAN = FHIRDefinedType.builder().value(Value.CARE_PLAN).build();
    public static final FHIRDefinedType CARE_TEAM = FHIRDefinedType.builder().value(Value.CARE_TEAM).build();
    public static final FHIRDefinedType CATALOG_ENTRY = FHIRDefinedType.builder().value(Value.CATALOG_ENTRY).build();
    public static final FHIRDefinedType CHARGE_ITEM = FHIRDefinedType.builder().value(Value.CHARGE_ITEM).build();
    public static final FHIRDefinedType CHARGE_ITEM_DEFINITION = FHIRDefinedType.builder().value(Value.CHARGE_ITEM_DEFINITION).build();
    public static final FHIRDefinedType CITATION = FHIRDefinedType.builder().value(Value.CITATION).build();
    public static final FHIRDefinedType CLAIM = FHIRDefinedType.builder().value(Value.CLAIM).build();
    public static final FHIRDefinedType CLAIM_RESPONSE = FHIRDefinedType.builder().value(Value.CLAIM_RESPONSE).build();
    public static final FHIRDefinedType CLINICAL_IMPRESSION = FHIRDefinedType.builder().value(Value.CLINICAL_IMPRESSION).build();
    public static final FHIRDefinedType CLINICAL_USE_DEFINITION = FHIRDefinedType.builder().value(Value.CLINICAL_USE_DEFINITION).build();
    public static final FHIRDefinedType CODE_SYSTEM = FHIRDefinedType.builder().value(Value.CODE_SYSTEM).build();
    public static final FHIRDefinedType COMMUNICATION = FHIRDefinedType.builder().value(Value.COMMUNICATION).build();
    public static final FHIRDefinedType COMMUNICATION_REQUEST = FHIRDefinedType.builder().value(Value.COMMUNICATION_REQUEST).build();
    public static final FHIRDefinedType COMPARTMENT_DEFINITION = FHIRDefinedType.builder().value(Value.COMPARTMENT_DEFINITION).build();
    public static final FHIRDefinedType COMPOSITION = FHIRDefinedType.builder().value(Value.COMPOSITION).build();
    public static final FHIRDefinedType CONCEPT_MAP = FHIRDefinedType.builder().value(Value.CONCEPT_MAP).build();
    public static final FHIRDefinedType CONDITION = FHIRDefinedType.builder().value(Value.CONDITION).build();
    public static final FHIRDefinedType CONSENT = FHIRDefinedType.builder().value(Value.CONSENT).build();
    public static final FHIRDefinedType CONTRACT = FHIRDefinedType.builder().value(Value.CONTRACT).build();
    public static final FHIRDefinedType COVERAGE = FHIRDefinedType.builder().value(Value.COVERAGE).build();
    public static final FHIRDefinedType COVERAGE_ELIGIBILITY_REQUEST = FHIRDefinedType.builder().value(Value.COVERAGE_ELIGIBILITY_REQUEST).build();
    public static final FHIRDefinedType COVERAGE_ELIGIBILITY_RESPONSE = FHIRDefinedType.builder().value(Value.COVERAGE_ELIGIBILITY_RESPONSE).build();
    public static final FHIRDefinedType DETECTED_ISSUE = FHIRDefinedType.builder().value(Value.DETECTED_ISSUE).build();
    public static final FHIRDefinedType DEVICE = FHIRDefinedType.builder().value(Value.DEVICE).build();
    public static final FHIRDefinedType DEVICE_DEFINITION = FHIRDefinedType.builder().value(Value.DEVICE_DEFINITION).build();
    public static final FHIRDefinedType DEVICE_METRIC = FHIRDefinedType.builder().value(Value.DEVICE_METRIC).build();
    public static final FHIRDefinedType DEVICE_REQUEST = FHIRDefinedType.builder().value(Value.DEVICE_REQUEST).build();
    public static final FHIRDefinedType DEVICE_USE_STATEMENT = FHIRDefinedType.builder().value(Value.DEVICE_USE_STATEMENT).build();
    public static final FHIRDefinedType DIAGNOSTIC_REPORT = FHIRDefinedType.builder().value(Value.DIAGNOSTIC_REPORT).build();
    public static final FHIRDefinedType DOCUMENT_MANIFEST = FHIRDefinedType.builder().value(Value.DOCUMENT_MANIFEST).build();
    public static final FHIRDefinedType DOCUMENT_REFERENCE = FHIRDefinedType.builder().value(Value.DOCUMENT_REFERENCE).build();
    public static final FHIRDefinedType ENCOUNTER = FHIRDefinedType.builder().value(Value.ENCOUNTER).build();
    public static final FHIRDefinedType ENDPOINT = FHIRDefinedType.builder().value(Value.ENDPOINT).build();
    public static final FHIRDefinedType ENROLLMENT_REQUEST = FHIRDefinedType.builder().value(Value.ENROLLMENT_REQUEST).build();
    public static final FHIRDefinedType ENROLLMENT_RESPONSE = FHIRDefinedType.builder().value(Value.ENROLLMENT_RESPONSE).build();
    public static final FHIRDefinedType EPISODE_OF_CARE = FHIRDefinedType.builder().value(Value.EPISODE_OF_CARE).build();
    public static final FHIRDefinedType EVENT_DEFINITION = FHIRDefinedType.builder().value(Value.EVENT_DEFINITION).build();
    public static final FHIRDefinedType EVIDENCE = FHIRDefinedType.builder().value(Value.EVIDENCE).build();
    public static final FHIRDefinedType EVIDENCE_REPORT = FHIRDefinedType.builder().value(Value.EVIDENCE_REPORT).build();
    public static final FHIRDefinedType EVIDENCE_VARIABLE = FHIRDefinedType.builder().value(Value.EVIDENCE_VARIABLE).build();
    public static final FHIRDefinedType EXAMPLE_SCENARIO = FHIRDefinedType.builder().value(Value.EXAMPLE_SCENARIO).build();
    public static final FHIRDefinedType EXPLANATION_OF_BENEFIT = FHIRDefinedType.builder().value(Value.EXPLANATION_OF_BENEFIT).build();
    public static final FHIRDefinedType FAMILY_MEMBER_HISTORY = FHIRDefinedType.builder().value(Value.FAMILY_MEMBER_HISTORY).build();
    public static final FHIRDefinedType FLAG = FHIRDefinedType.builder().value(Value.FLAG).build();
    public static final FHIRDefinedType GOAL = FHIRDefinedType.builder().value(Value.GOAL).build();
    public static final FHIRDefinedType GRAPH_DEFINITION = FHIRDefinedType.builder().value(Value.GRAPH_DEFINITION).build();
    public static final FHIRDefinedType GROUP = FHIRDefinedType.builder().value(Value.GROUP).build();
    public static final FHIRDefinedType GUIDANCE_RESPONSE = FHIRDefinedType.builder().value(Value.GUIDANCE_RESPONSE).build();
    public static final FHIRDefinedType HEALTHCARE_SERVICE = FHIRDefinedType.builder().value(Value.HEALTHCARE_SERVICE).build();
    public static final FHIRDefinedType IMAGING_STUDY = FHIRDefinedType.builder().value(Value.IMAGING_STUDY).build();
    public static final FHIRDefinedType IMMUNIZATION = FHIRDefinedType.builder().value(Value.IMMUNIZATION).build();
    public static final FHIRDefinedType IMMUNIZATION_EVALUATION = FHIRDefinedType.builder().value(Value.IMMUNIZATION_EVALUATION).build();
    public static final FHIRDefinedType IMMUNIZATION_RECOMMENDATION = FHIRDefinedType.builder().value(Value.IMMUNIZATION_RECOMMENDATION).build();
    public static final FHIRDefinedType IMPLEMENTATION_GUIDE = FHIRDefinedType.builder().value(Value.IMPLEMENTATION_GUIDE).build();
    public static final FHIRDefinedType INGREDIENT = FHIRDefinedType.builder().value(Value.INGREDIENT).build();
    public static final FHIRDefinedType INSURANCE_PLAN = FHIRDefinedType.builder().value(Value.INSURANCE_PLAN).build();
    public static final FHIRDefinedType INVOICE = FHIRDefinedType.builder().value(Value.INVOICE).build();
    public static final FHIRDefinedType LIBRARY = FHIRDefinedType.builder().value(Value.LIBRARY).build();
    public static final FHIRDefinedType LINKAGE = FHIRDefinedType.builder().value(Value.LINKAGE).build();
    public static final FHIRDefinedType LIST = FHIRDefinedType.builder().value(Value.LIST).build();
    public static final FHIRDefinedType LOCATION = FHIRDefinedType.builder().value(Value.LOCATION).build();
    public static final FHIRDefinedType MANUFACTURED_ITEM_DEFINITION = FHIRDefinedType.builder().value(Value.MANUFACTURED_ITEM_DEFINITION).build();
    public static final FHIRDefinedType MEASURE = FHIRDefinedType.builder().value(Value.MEASURE).build();
    public static final FHIRDefinedType MEASURE_REPORT = FHIRDefinedType.builder().value(Value.MEASURE_REPORT).build();
    public static final FHIRDefinedType MEDIA = FHIRDefinedType.builder().value(Value.MEDIA).build();
    public static final FHIRDefinedType MEDICATION = FHIRDefinedType.builder().value(Value.MEDICATION).build();
    public static final FHIRDefinedType MEDICATION_ADMINISTRATION = FHIRDefinedType.builder().value(Value.MEDICATION_ADMINISTRATION).build();
    public static final FHIRDefinedType MEDICATION_DISPENSE = FHIRDefinedType.builder().value(Value.MEDICATION_DISPENSE).build();
    public static final FHIRDefinedType MEDICATION_KNOWLEDGE = FHIRDefinedType.builder().value(Value.MEDICATION_KNOWLEDGE).build();
    public static final FHIRDefinedType MEDICATION_REQUEST = FHIRDefinedType.builder().value(Value.MEDICATION_REQUEST).build();
    public static final FHIRDefinedType MEDICATION_STATEMENT = FHIRDefinedType.builder().value(Value.MEDICATION_STATEMENT).build();
    public static final FHIRDefinedType MEDICINAL_PRODUCT_DEFINITION = FHIRDefinedType.builder().value(Value.MEDICINAL_PRODUCT_DEFINITION).build();
    public static final FHIRDefinedType MESSAGE_DEFINITION = FHIRDefinedType.builder().value(Value.MESSAGE_DEFINITION).build();
    public static final FHIRDefinedType MESSAGE_HEADER = FHIRDefinedType.builder().value(Value.MESSAGE_HEADER).build();
    public static final FHIRDefinedType MOLECULAR_SEQUENCE = FHIRDefinedType.builder().value(Value.MOLECULAR_SEQUENCE).build();
    public static final FHIRDefinedType NAMING_SYSTEM = FHIRDefinedType.builder().value(Value.NAMING_SYSTEM).build();
    public static final FHIRDefinedType NUTRITION_ORDER = FHIRDefinedType.builder().value(Value.NUTRITION_ORDER).build();
    public static final FHIRDefinedType NUTRITION_PRODUCT = FHIRDefinedType.builder().value(Value.NUTRITION_PRODUCT).build();
    public static final FHIRDefinedType OBSERVATION = FHIRDefinedType.builder().value(Value.OBSERVATION).build();
    public static final FHIRDefinedType OBSERVATION_DEFINITION = FHIRDefinedType.builder().value(Value.OBSERVATION_DEFINITION).build();
    public static final FHIRDefinedType OPERATION_DEFINITION = FHIRDefinedType.builder().value(Value.OPERATION_DEFINITION).build();
    public static final FHIRDefinedType OPERATION_OUTCOME = FHIRDefinedType.builder().value(Value.OPERATION_OUTCOME).build();
    public static final FHIRDefinedType ORGANIZATION = FHIRDefinedType.builder().value(Value.ORGANIZATION).build();
    public static final FHIRDefinedType ORGANIZATION_AFFILIATION = FHIRDefinedType.builder().value(Value.ORGANIZATION_AFFILIATION).build();
    public static final FHIRDefinedType PACKAGED_PRODUCT_DEFINITION = FHIRDefinedType.builder().value(Value.PACKAGED_PRODUCT_DEFINITION).build();
    public static final FHIRDefinedType PATIENT = FHIRDefinedType.builder().value(Value.PATIENT).build();
    public static final FHIRDefinedType PAYMENT_NOTICE = FHIRDefinedType.builder().value(Value.PAYMENT_NOTICE).build();
    public static final FHIRDefinedType PAYMENT_RECONCILIATION = FHIRDefinedType.builder().value(Value.PAYMENT_RECONCILIATION).build();
    public static final FHIRDefinedType PERSON = FHIRDefinedType.builder().value(Value.PERSON).build();
    public static final FHIRDefinedType PLAN_DEFINITION = FHIRDefinedType.builder().value(Value.PLAN_DEFINITION).build();
    public static final FHIRDefinedType PRACTITIONER = FHIRDefinedType.builder().value(Value.PRACTITIONER).build();
    public static final FHIRDefinedType PRACTITIONER_ROLE = FHIRDefinedType.builder().value(Value.PRACTITIONER_ROLE).build();
    public static final FHIRDefinedType PROCEDURE = FHIRDefinedType.builder().value(Value.PROCEDURE).build();
    public static final FHIRDefinedType PROVENANCE = FHIRDefinedType.builder().value(Value.PROVENANCE).build();
    public static final FHIRDefinedType QUESTIONNAIRE = FHIRDefinedType.builder().value(Value.QUESTIONNAIRE).build();
    public static final FHIRDefinedType QUESTIONNAIRE_RESPONSE = FHIRDefinedType.builder().value(Value.QUESTIONNAIRE_RESPONSE).build();
    public static final FHIRDefinedType REGULATED_AUTHORIZATION = FHIRDefinedType.builder().value(Value.REGULATED_AUTHORIZATION).build();
    public static final FHIRDefinedType RELATED_PERSON = FHIRDefinedType.builder().value(Value.RELATED_PERSON).build();
    public static final FHIRDefinedType REQUEST_GROUP = FHIRDefinedType.builder().value(Value.REQUEST_GROUP).build();
    public static final FHIRDefinedType RESEARCH_DEFINITION = FHIRDefinedType.builder().value(Value.RESEARCH_DEFINITION).build();
    public static final FHIRDefinedType RESEARCH_ELEMENT_DEFINITION = FHIRDefinedType.builder().value(Value.RESEARCH_ELEMENT_DEFINITION).build();
    public static final FHIRDefinedType RESEARCH_STUDY = FHIRDefinedType.builder().value(Value.RESEARCH_STUDY).build();
    public static final FHIRDefinedType RESEARCH_SUBJECT = FHIRDefinedType.builder().value(Value.RESEARCH_SUBJECT).build();
    public static final FHIRDefinedType RISK_ASSESSMENT = FHIRDefinedType.builder().value(Value.RISK_ASSESSMENT).build();
    public static final FHIRDefinedType SCHEDULE = FHIRDefinedType.builder().value(Value.SCHEDULE).build();
    public static final FHIRDefinedType SEARCH_PARAMETER = FHIRDefinedType.builder().value(Value.SEARCH_PARAMETER).build();
    public static final FHIRDefinedType SERVICE_REQUEST = FHIRDefinedType.builder().value(Value.SERVICE_REQUEST).build();
    public static final FHIRDefinedType SLOT = FHIRDefinedType.builder().value(Value.SLOT).build();
    public static final FHIRDefinedType SPECIMEN = FHIRDefinedType.builder().value(Value.SPECIMEN).build();
    public static final FHIRDefinedType SPECIMEN_DEFINITION = FHIRDefinedType.builder().value(Value.SPECIMEN_DEFINITION).build();
    public static final FHIRDefinedType STRUCTURE_DEFINITION = FHIRDefinedType.builder().value(Value.STRUCTURE_DEFINITION).build();
    public static final FHIRDefinedType STRUCTURE_MAP = FHIRDefinedType.builder().value(Value.STRUCTURE_MAP).build();
    public static final FHIRDefinedType SUBSCRIPTION = FHIRDefinedType.builder().value(Value.SUBSCRIPTION).build();
    public static final FHIRDefinedType SUBSCRIPTION_STATUS = FHIRDefinedType.builder().value(Value.SUBSCRIPTION_STATUS).build();
    public static final FHIRDefinedType SUBSCRIPTION_TOPIC = FHIRDefinedType.builder().value(Value.SUBSCRIPTION_TOPIC).build();
    public static final FHIRDefinedType SUBSTANCE = FHIRDefinedType.builder().value(Value.SUBSTANCE).build();
    public static final FHIRDefinedType SUBSTANCE_DEFINITION = FHIRDefinedType.builder().value(Value.SUBSTANCE_DEFINITION).build();
    public static final FHIRDefinedType SUPPLY_DELIVERY = FHIRDefinedType.builder().value(Value.SUPPLY_DELIVERY).build();
    public static final FHIRDefinedType SUPPLY_REQUEST = FHIRDefinedType.builder().value(Value.SUPPLY_REQUEST).build();
    public static final FHIRDefinedType TASK = FHIRDefinedType.builder().value(Value.TASK).build();
    public static final FHIRDefinedType TERMINOLOGY_CAPABILITIES = FHIRDefinedType.builder().value(Value.TERMINOLOGY_CAPABILITIES).build();
    public static final FHIRDefinedType TEST_REPORT = FHIRDefinedType.builder().value(Value.TEST_REPORT).build();
    public static final FHIRDefinedType TEST_SCRIPT = FHIRDefinedType.builder().value(Value.TEST_SCRIPT).build();
    public static final FHIRDefinedType VALUE_SET = FHIRDefinedType.builder().value(Value.VALUE_SET).build();
    public static final FHIRDefinedType VERIFICATION_RESULT = FHIRDefinedType.builder().value(Value.VERIFICATION_RESULT).build();
    public static final FHIRDefinedType VISION_PRESCRIPTION = FHIRDefinedType.builder().value(Value.VISION_PRESCRIPTION).build();
    public static final FHIRDefinedType PARAMETERS = FHIRDefinedType.builder().value(Value.PARAMETERS).build();
    private volatile int hashCode;

    private FHIRDefinedType(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static FHIRDefinedType of(Value value) {
        switch (value) {
            case ADDRESS: {
                return ADDRESS;
            }
            case AGE: {
                return AGE;
            }
            case ANNOTATION: {
                return ANNOTATION;
            }
            case ATTACHMENT: {
                return ATTACHMENT;
            }
            case BACKBONE_ELEMENT: {
                return BACKBONE_ELEMENT;
            }
            case CODEABLE_CONCEPT: {
                return CODEABLE_CONCEPT;
            }
            case CODEABLE_REFERENCE: {
                return CODEABLE_REFERENCE;
            }
            case CODING: {
                return CODING;
            }
            case CONTACT_DETAIL: {
                return CONTACT_DETAIL;
            }
            case CONTACT_POINT: {
                return CONTACT_POINT;
            }
            case CONTRIBUTOR: {
                return CONTRIBUTOR;
            }
            case COUNT: {
                return COUNT;
            }
            case DATA_REQUIREMENT: {
                return DATA_REQUIREMENT;
            }
            case DISTANCE: {
                return DISTANCE;
            }
            case DOSAGE: {
                return DOSAGE;
            }
            case DURATION: {
                return DURATION;
            }
            case ELEMENT: {
                return ELEMENT;
            }
            case ELEMENT_DEFINITION: {
                return ELEMENT_DEFINITION;
            }
            case EXPRESSION: {
                return EXPRESSION;
            }
            case EXTENSION: {
                return EXTENSION;
            }
            case HUMAN_NAME: {
                return HUMAN_NAME;
            }
            case IDENTIFIER: {
                return IDENTIFIER;
            }
            case MARKETING_STATUS: {
                return MARKETING_STATUS;
            }
            case META: {
                return META;
            }
            case MONEY: {
                return MONEY;
            }
            case MONEY_QUANTITY: {
                return MONEY_QUANTITY;
            }
            case NARRATIVE: {
                return NARRATIVE;
            }
            case PARAMETER_DEFINITION: {
                return PARAMETER_DEFINITION;
            }
            case PERIOD: {
                return PERIOD;
            }
            case POPULATION: {
                return POPULATION;
            }
            case PROD_CHARACTERISTIC: {
                return PROD_CHARACTERISTIC;
            }
            case PRODUCT_SHELF_LIFE: {
                return PRODUCT_SHELF_LIFE;
            }
            case QUANTITY: {
                return QUANTITY;
            }
            case RANGE: {
                return RANGE;
            }
            case RATIO: {
                return RATIO;
            }
            case RATIO_RANGE: {
                return RATIO_RANGE;
            }
            case REFERENCE: {
                return REFERENCE;
            }
            case RELATED_ARTIFACT: {
                return RELATED_ARTIFACT;
            }
            case SAMPLED_DATA: {
                return SAMPLED_DATA;
            }
            case SIGNATURE: {
                return SIGNATURE;
            }
            case SIMPLE_QUANTITY: {
                return SIMPLE_QUANTITY;
            }
            case TIMING: {
                return TIMING;
            }
            case TRIGGER_DEFINITION: {
                return TRIGGER_DEFINITION;
            }
            case USAGE_CONTEXT: {
                return USAGE_CONTEXT;
            }
            case BASE64BINARY: {
                return BASE64BINARY;
            }
            case BOOLEAN: {
                return BOOLEAN;
            }
            case CANONICAL: {
                return CANONICAL;
            }
            case CODE: {
                return CODE;
            }
            case DATE: {
                return DATE;
            }
            case DATE_TIME: {
                return DATE_TIME;
            }
            case DECIMAL: {
                return DECIMAL;
            }
            case ID: {
                return ID;
            }
            case INSTANT: {
                return INSTANT;
            }
            case INTEGER: {
                return INTEGER;
            }
            case MARKDOWN: {
                return MARKDOWN;
            }
            case OID: {
                return OID;
            }
            case POSITIVE_INT: {
                return POSITIVE_INT;
            }
            case STRING: {
                return STRING;
            }
            case TIME: {
                return TIME;
            }
            case UNSIGNED_INT: {
                return UNSIGNED_INT;
            }
            case URI: {
                return URI;
            }
            case URL: {
                return URL;
            }
            case UUID: {
                return UUID;
            }
            case XHTML: {
                return XHTML;
            }
            case RESOURCE: {
                return RESOURCE;
            }
            case BINARY: {
                return BINARY;
            }
            case BUNDLE: {
                return BUNDLE;
            }
            case DOMAIN_RESOURCE: {
                return DOMAIN_RESOURCE;
            }
            case ACCOUNT: {
                return ACCOUNT;
            }
            case ACTIVITY_DEFINITION: {
                return ACTIVITY_DEFINITION;
            }
            case ADMINISTRABLE_PRODUCT_DEFINITION: {
                return ADMINISTRABLE_PRODUCT_DEFINITION;
            }
            case ADVERSE_EVENT: {
                return ADVERSE_EVENT;
            }
            case ALLERGY_INTOLERANCE: {
                return ALLERGY_INTOLERANCE;
            }
            case APPOINTMENT: {
                return APPOINTMENT;
            }
            case APPOINTMENT_RESPONSE: {
                return APPOINTMENT_RESPONSE;
            }
            case AUDIT_EVENT: {
                return AUDIT_EVENT;
            }
            case BASIC: {
                return BASIC;
            }
            case BIOLOGICALLY_DERIVED_PRODUCT: {
                return BIOLOGICALLY_DERIVED_PRODUCT;
            }
            case BODY_STRUCTURE: {
                return BODY_STRUCTURE;
            }
            case CAPABILITY_STATEMENT: {
                return CAPABILITY_STATEMENT;
            }
            case CARE_PLAN: {
                return CARE_PLAN;
            }
            case CARE_TEAM: {
                return CARE_TEAM;
            }
            case CATALOG_ENTRY: {
                return CATALOG_ENTRY;
            }
            case CHARGE_ITEM: {
                return CHARGE_ITEM;
            }
            case CHARGE_ITEM_DEFINITION: {
                return CHARGE_ITEM_DEFINITION;
            }
            case CITATION: {
                return CITATION;
            }
            case CLAIM: {
                return CLAIM;
            }
            case CLAIM_RESPONSE: {
                return CLAIM_RESPONSE;
            }
            case CLINICAL_IMPRESSION: {
                return CLINICAL_IMPRESSION;
            }
            case CLINICAL_USE_DEFINITION: {
                return CLINICAL_USE_DEFINITION;
            }
            case CODE_SYSTEM: {
                return CODE_SYSTEM;
            }
            case COMMUNICATION: {
                return COMMUNICATION;
            }
            case COMMUNICATION_REQUEST: {
                return COMMUNICATION_REQUEST;
            }
            case COMPARTMENT_DEFINITION: {
                return COMPARTMENT_DEFINITION;
            }
            case COMPOSITION: {
                return COMPOSITION;
            }
            case CONCEPT_MAP: {
                return CONCEPT_MAP;
            }
            case CONDITION: {
                return CONDITION;
            }
            case CONSENT: {
                return CONSENT;
            }
            case CONTRACT: {
                return CONTRACT;
            }
            case COVERAGE: {
                return COVERAGE;
            }
            case COVERAGE_ELIGIBILITY_REQUEST: {
                return COVERAGE_ELIGIBILITY_REQUEST;
            }
            case COVERAGE_ELIGIBILITY_RESPONSE: {
                return COVERAGE_ELIGIBILITY_RESPONSE;
            }
            case DETECTED_ISSUE: {
                return DETECTED_ISSUE;
            }
            case DEVICE: {
                return DEVICE;
            }
            case DEVICE_DEFINITION: {
                return DEVICE_DEFINITION;
            }
            case DEVICE_METRIC: {
                return DEVICE_METRIC;
            }
            case DEVICE_REQUEST: {
                return DEVICE_REQUEST;
            }
            case DEVICE_USE_STATEMENT: {
                return DEVICE_USE_STATEMENT;
            }
            case DIAGNOSTIC_REPORT: {
                return DIAGNOSTIC_REPORT;
            }
            case DOCUMENT_MANIFEST: {
                return DOCUMENT_MANIFEST;
            }
            case DOCUMENT_REFERENCE: {
                return DOCUMENT_REFERENCE;
            }
            case ENCOUNTER: {
                return ENCOUNTER;
            }
            case ENDPOINT: {
                return ENDPOINT;
            }
            case ENROLLMENT_REQUEST: {
                return ENROLLMENT_REQUEST;
            }
            case ENROLLMENT_RESPONSE: {
                return ENROLLMENT_RESPONSE;
            }
            case EPISODE_OF_CARE: {
                return EPISODE_OF_CARE;
            }
            case EVENT_DEFINITION: {
                return EVENT_DEFINITION;
            }
            case EVIDENCE: {
                return EVIDENCE;
            }
            case EVIDENCE_REPORT: {
                return EVIDENCE_REPORT;
            }
            case EVIDENCE_VARIABLE: {
                return EVIDENCE_VARIABLE;
            }
            case EXAMPLE_SCENARIO: {
                return EXAMPLE_SCENARIO;
            }
            case EXPLANATION_OF_BENEFIT: {
                return EXPLANATION_OF_BENEFIT;
            }
            case FAMILY_MEMBER_HISTORY: {
                return FAMILY_MEMBER_HISTORY;
            }
            case FLAG: {
                return FLAG;
            }
            case GOAL: {
                return GOAL;
            }
            case GRAPH_DEFINITION: {
                return GRAPH_DEFINITION;
            }
            case GROUP: {
                return GROUP;
            }
            case GUIDANCE_RESPONSE: {
                return GUIDANCE_RESPONSE;
            }
            case HEALTHCARE_SERVICE: {
                return HEALTHCARE_SERVICE;
            }
            case IMAGING_STUDY: {
                return IMAGING_STUDY;
            }
            case IMMUNIZATION: {
                return IMMUNIZATION;
            }
            case IMMUNIZATION_EVALUATION: {
                return IMMUNIZATION_EVALUATION;
            }
            case IMMUNIZATION_RECOMMENDATION: {
                return IMMUNIZATION_RECOMMENDATION;
            }
            case IMPLEMENTATION_GUIDE: {
                return IMPLEMENTATION_GUIDE;
            }
            case INGREDIENT: {
                return INGREDIENT;
            }
            case INSURANCE_PLAN: {
                return INSURANCE_PLAN;
            }
            case INVOICE: {
                return INVOICE;
            }
            case LIBRARY: {
                return LIBRARY;
            }
            case LINKAGE: {
                return LINKAGE;
            }
            case LIST: {
                return LIST;
            }
            case LOCATION: {
                return LOCATION;
            }
            case MANUFACTURED_ITEM_DEFINITION: {
                return MANUFACTURED_ITEM_DEFINITION;
            }
            case MEASURE: {
                return MEASURE;
            }
            case MEASURE_REPORT: {
                return MEASURE_REPORT;
            }
            case MEDIA: {
                return MEDIA;
            }
            case MEDICATION: {
                return MEDICATION;
            }
            case MEDICATION_ADMINISTRATION: {
                return MEDICATION_ADMINISTRATION;
            }
            case MEDICATION_DISPENSE: {
                return MEDICATION_DISPENSE;
            }
            case MEDICATION_KNOWLEDGE: {
                return MEDICATION_KNOWLEDGE;
            }
            case MEDICATION_REQUEST: {
                return MEDICATION_REQUEST;
            }
            case MEDICATION_STATEMENT: {
                return MEDICATION_STATEMENT;
            }
            case MEDICINAL_PRODUCT_DEFINITION: {
                return MEDICINAL_PRODUCT_DEFINITION;
            }
            case MESSAGE_DEFINITION: {
                return MESSAGE_DEFINITION;
            }
            case MESSAGE_HEADER: {
                return MESSAGE_HEADER;
            }
            case MOLECULAR_SEQUENCE: {
                return MOLECULAR_SEQUENCE;
            }
            case NAMING_SYSTEM: {
                return NAMING_SYSTEM;
            }
            case NUTRITION_ORDER: {
                return NUTRITION_ORDER;
            }
            case NUTRITION_PRODUCT: {
                return NUTRITION_PRODUCT;
            }
            case OBSERVATION: {
                return OBSERVATION;
            }
            case OBSERVATION_DEFINITION: {
                return OBSERVATION_DEFINITION;
            }
            case OPERATION_DEFINITION: {
                return OPERATION_DEFINITION;
            }
            case OPERATION_OUTCOME: {
                return OPERATION_OUTCOME;
            }
            case ORGANIZATION: {
                return ORGANIZATION;
            }
            case ORGANIZATION_AFFILIATION: {
                return ORGANIZATION_AFFILIATION;
            }
            case PACKAGED_PRODUCT_DEFINITION: {
                return PACKAGED_PRODUCT_DEFINITION;
            }
            case PATIENT: {
                return PATIENT;
            }
            case PAYMENT_NOTICE: {
                return PAYMENT_NOTICE;
            }
            case PAYMENT_RECONCILIATION: {
                return PAYMENT_RECONCILIATION;
            }
            case PERSON: {
                return PERSON;
            }
            case PLAN_DEFINITION: {
                return PLAN_DEFINITION;
            }
            case PRACTITIONER: {
                return PRACTITIONER;
            }
            case PRACTITIONER_ROLE: {
                return PRACTITIONER_ROLE;
            }
            case PROCEDURE: {
                return PROCEDURE;
            }
            case PROVENANCE: {
                return PROVENANCE;
            }
            case QUESTIONNAIRE: {
                return QUESTIONNAIRE;
            }
            case QUESTIONNAIRE_RESPONSE: {
                return QUESTIONNAIRE_RESPONSE;
            }
            case REGULATED_AUTHORIZATION: {
                return REGULATED_AUTHORIZATION;
            }
            case RELATED_PERSON: {
                return RELATED_PERSON;
            }
            case REQUEST_GROUP: {
                return REQUEST_GROUP;
            }
            case RESEARCH_DEFINITION: {
                return RESEARCH_DEFINITION;
            }
            case RESEARCH_ELEMENT_DEFINITION: {
                return RESEARCH_ELEMENT_DEFINITION;
            }
            case RESEARCH_STUDY: {
                return RESEARCH_STUDY;
            }
            case RESEARCH_SUBJECT: {
                return RESEARCH_SUBJECT;
            }
            case RISK_ASSESSMENT: {
                return RISK_ASSESSMENT;
            }
            case SCHEDULE: {
                return SCHEDULE;
            }
            case SEARCH_PARAMETER: {
                return SEARCH_PARAMETER;
            }
            case SERVICE_REQUEST: {
                return SERVICE_REQUEST;
            }
            case SLOT: {
                return SLOT;
            }
            case SPECIMEN: {
                return SPECIMEN;
            }
            case SPECIMEN_DEFINITION: {
                return SPECIMEN_DEFINITION;
            }
            case STRUCTURE_DEFINITION: {
                return STRUCTURE_DEFINITION;
            }
            case STRUCTURE_MAP: {
                return STRUCTURE_MAP;
            }
            case SUBSCRIPTION: {
                return SUBSCRIPTION;
            }
            case SUBSCRIPTION_STATUS: {
                return SUBSCRIPTION_STATUS;
            }
            case SUBSCRIPTION_TOPIC: {
                return SUBSCRIPTION_TOPIC;
            }
            case SUBSTANCE: {
                return SUBSTANCE;
            }
            case SUBSTANCE_DEFINITION: {
                return SUBSTANCE_DEFINITION;
            }
            case SUPPLY_DELIVERY: {
                return SUPPLY_DELIVERY;
            }
            case SUPPLY_REQUEST: {
                return SUPPLY_REQUEST;
            }
            case TASK: {
                return TASK;
            }
            case TERMINOLOGY_CAPABILITIES: {
                return TERMINOLOGY_CAPABILITIES;
            }
            case TEST_REPORT: {
                return TEST_REPORT;
            }
            case TEST_SCRIPT: {
                return TEST_SCRIPT;
            }
            case VALUE_SET: {
                return VALUE_SET;
            }
            case VERIFICATION_RESULT: {
                return VERIFICATION_RESULT;
            }
            case VISION_PRESCRIPTION: {
                return VISION_PRESCRIPTION;
            }
            case PARAMETERS: {
                return PARAMETERS;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static FHIRDefinedType of(java.lang.String value) {
        return FHIRDefinedType.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return FHIRDefinedType.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return FHIRDefinedType.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FHIRDefinedType other = (FHIRDefinedType)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        ADDRESS("Address"),
        AGE("Age"),
        ANNOTATION("Annotation"),
        ATTACHMENT("Attachment"),
        BACKBONE_ELEMENT("BackboneElement"),
        CODEABLE_CONCEPT("CodeableConcept"),
        CODEABLE_REFERENCE("CodeableReference"),
        CODING("Coding"),
        CONTACT_DETAIL("ContactDetail"),
        CONTACT_POINT("ContactPoint"),
        CONTRIBUTOR("Contributor"),
        COUNT("Count"),
        DATA_REQUIREMENT("DataRequirement"),
        DISTANCE("Distance"),
        DOSAGE("Dosage"),
        DURATION("Duration"),
        ELEMENT("Element"),
        ELEMENT_DEFINITION("ElementDefinition"),
        EXPRESSION("Expression"),
        EXTENSION("Extension"),
        HUMAN_NAME("HumanName"),
        IDENTIFIER("Identifier"),
        MARKETING_STATUS("MarketingStatus"),
        META("Meta"),
        MONEY("Money"),
        MONEY_QUANTITY("MoneyQuantity"),
        NARRATIVE("Narrative"),
        PARAMETER_DEFINITION("ParameterDefinition"),
        PERIOD("Period"),
        POPULATION("Population"),
        PROD_CHARACTERISTIC("ProdCharacteristic"),
        PRODUCT_SHELF_LIFE("ProductShelfLife"),
        QUANTITY("Quantity"),
        RANGE("Range"),
        RATIO("Ratio"),
        RATIO_RANGE("RatioRange"),
        REFERENCE("Reference"),
        RELATED_ARTIFACT("RelatedArtifact"),
        SAMPLED_DATA("SampledData"),
        SIGNATURE("Signature"),
        SIMPLE_QUANTITY("SimpleQuantity"),
        TIMING("Timing"),
        TRIGGER_DEFINITION("TriggerDefinition"),
        USAGE_CONTEXT("UsageContext"),
        BASE64BINARY("base64Binary"),
        BOOLEAN("boolean"),
        CANONICAL("canonical"),
        CODE("code"),
        DATE("date"),
        DATE_TIME("dateTime"),
        DECIMAL("decimal"),
        ID("id"),
        INSTANT("instant"),
        INTEGER("integer"),
        MARKDOWN("markdown"),
        OID("oid"),
        POSITIVE_INT("positiveInt"),
        STRING("string"),
        TIME("time"),
        UNSIGNED_INT("unsignedInt"),
        URI("uri"),
        URL("url"),
        UUID("uuid"),
        XHTML("xhtml"),
        RESOURCE("Resource"),
        BINARY("Binary"),
        BUNDLE("Bundle"),
        DOMAIN_RESOURCE("DomainResource"),
        ACCOUNT("Account"),
        ACTIVITY_DEFINITION("ActivityDefinition"),
        ADMINISTRABLE_PRODUCT_DEFINITION("AdministrableProductDefinition"),
        ADVERSE_EVENT("AdverseEvent"),
        ALLERGY_INTOLERANCE("AllergyIntolerance"),
        APPOINTMENT("Appointment"),
        APPOINTMENT_RESPONSE("AppointmentResponse"),
        AUDIT_EVENT("AuditEvent"),
        BASIC("Basic"),
        BIOLOGICALLY_DERIVED_PRODUCT("BiologicallyDerivedProduct"),
        BODY_STRUCTURE("BodyStructure"),
        CAPABILITY_STATEMENT("CapabilityStatement"),
        CARE_PLAN("CarePlan"),
        CARE_TEAM("CareTeam"),
        CATALOG_ENTRY("CatalogEntry"),
        CHARGE_ITEM("ChargeItem"),
        CHARGE_ITEM_DEFINITION("ChargeItemDefinition"),
        CITATION("Citation"),
        CLAIM("Claim"),
        CLAIM_RESPONSE("ClaimResponse"),
        CLINICAL_IMPRESSION("ClinicalImpression"),
        CLINICAL_USE_DEFINITION("ClinicalUseDefinition"),
        CODE_SYSTEM("CodeSystem"),
        COMMUNICATION("Communication"),
        COMMUNICATION_REQUEST("CommunicationRequest"),
        COMPARTMENT_DEFINITION("CompartmentDefinition"),
        COMPOSITION("Composition"),
        CONCEPT_MAP("ConceptMap"),
        CONDITION("Condition"),
        CONSENT("Consent"),
        CONTRACT("Contract"),
        COVERAGE("Coverage"),
        COVERAGE_ELIGIBILITY_REQUEST("CoverageEligibilityRequest"),
        COVERAGE_ELIGIBILITY_RESPONSE("CoverageEligibilityResponse"),
        DETECTED_ISSUE("DetectedIssue"),
        DEVICE("Device"),
        DEVICE_DEFINITION("DeviceDefinition"),
        DEVICE_METRIC("DeviceMetric"),
        DEVICE_REQUEST("DeviceRequest"),
        DEVICE_USE_STATEMENT("DeviceUseStatement"),
        DIAGNOSTIC_REPORT("DiagnosticReport"),
        DOCUMENT_MANIFEST("DocumentManifest"),
        DOCUMENT_REFERENCE("DocumentReference"),
        ENCOUNTER("Encounter"),
        ENDPOINT("Endpoint"),
        ENROLLMENT_REQUEST("EnrollmentRequest"),
        ENROLLMENT_RESPONSE("EnrollmentResponse"),
        EPISODE_OF_CARE("EpisodeOfCare"),
        EVENT_DEFINITION("EventDefinition"),
        EVIDENCE("Evidence"),
        EVIDENCE_REPORT("EvidenceReport"),
        EVIDENCE_VARIABLE("EvidenceVariable"),
        EXAMPLE_SCENARIO("ExampleScenario"),
        EXPLANATION_OF_BENEFIT("ExplanationOfBenefit"),
        FAMILY_MEMBER_HISTORY("FamilyMemberHistory"),
        FLAG("Flag"),
        GOAL("Goal"),
        GRAPH_DEFINITION("GraphDefinition"),
        GROUP("Group"),
        GUIDANCE_RESPONSE("GuidanceResponse"),
        HEALTHCARE_SERVICE("HealthcareService"),
        IMAGING_STUDY("ImagingStudy"),
        IMMUNIZATION("Immunization"),
        IMMUNIZATION_EVALUATION("ImmunizationEvaluation"),
        IMMUNIZATION_RECOMMENDATION("ImmunizationRecommendation"),
        IMPLEMENTATION_GUIDE("ImplementationGuide"),
        INGREDIENT("Ingredient"),
        INSURANCE_PLAN("InsurancePlan"),
        INVOICE("Invoice"),
        LIBRARY("Library"),
        LINKAGE("Linkage"),
        LIST("List"),
        LOCATION("Location"),
        MANUFACTURED_ITEM_DEFINITION("ManufacturedItemDefinition"),
        MEASURE("Measure"),
        MEASURE_REPORT("MeasureReport"),
        MEDIA("Media"),
        MEDICATION("Medication"),
        MEDICATION_ADMINISTRATION("MedicationAdministration"),
        MEDICATION_DISPENSE("MedicationDispense"),
        MEDICATION_KNOWLEDGE("MedicationKnowledge"),
        MEDICATION_REQUEST("MedicationRequest"),
        MEDICATION_STATEMENT("MedicationStatement"),
        MEDICINAL_PRODUCT_DEFINITION("MedicinalProductDefinition"),
        MESSAGE_DEFINITION("MessageDefinition"),
        MESSAGE_HEADER("MessageHeader"),
        MOLECULAR_SEQUENCE("MolecularSequence"),
        NAMING_SYSTEM("NamingSystem"),
        NUTRITION_ORDER("NutritionOrder"),
        NUTRITION_PRODUCT("NutritionProduct"),
        OBSERVATION("Observation"),
        OBSERVATION_DEFINITION("ObservationDefinition"),
        OPERATION_DEFINITION("OperationDefinition"),
        OPERATION_OUTCOME("OperationOutcome"),
        ORGANIZATION("Organization"),
        ORGANIZATION_AFFILIATION("OrganizationAffiliation"),
        PACKAGED_PRODUCT_DEFINITION("PackagedProductDefinition"),
        PATIENT("Patient"),
        PAYMENT_NOTICE("PaymentNotice"),
        PAYMENT_RECONCILIATION("PaymentReconciliation"),
        PERSON("Person"),
        PLAN_DEFINITION("PlanDefinition"),
        PRACTITIONER("Practitioner"),
        PRACTITIONER_ROLE("PractitionerRole"),
        PROCEDURE("Procedure"),
        PROVENANCE("Provenance"),
        QUESTIONNAIRE("Questionnaire"),
        QUESTIONNAIRE_RESPONSE("QuestionnaireResponse"),
        REGULATED_AUTHORIZATION("RegulatedAuthorization"),
        RELATED_PERSON("RelatedPerson"),
        REQUEST_GROUP("RequestGroup"),
        RESEARCH_DEFINITION("ResearchDefinition"),
        RESEARCH_ELEMENT_DEFINITION("ResearchElementDefinition"),
        RESEARCH_STUDY("ResearchStudy"),
        RESEARCH_SUBJECT("ResearchSubject"),
        RISK_ASSESSMENT("RiskAssessment"),
        SCHEDULE("Schedule"),
        SEARCH_PARAMETER("SearchParameter"),
        SERVICE_REQUEST("ServiceRequest"),
        SLOT("Slot"),
        SPECIMEN("Specimen"),
        SPECIMEN_DEFINITION("SpecimenDefinition"),
        STRUCTURE_DEFINITION("StructureDefinition"),
        STRUCTURE_MAP("StructureMap"),
        SUBSCRIPTION("Subscription"),
        SUBSCRIPTION_STATUS("SubscriptionStatus"),
        SUBSCRIPTION_TOPIC("SubscriptionTopic"),
        SUBSTANCE("Substance"),
        SUBSTANCE_DEFINITION("SubstanceDefinition"),
        SUPPLY_DELIVERY("SupplyDelivery"),
        SUPPLY_REQUEST("SupplyRequest"),
        TASK("Task"),
        TERMINOLOGY_CAPABILITIES("TerminologyCapabilities"),
        TEST_REPORT("TestReport"),
        TEST_SCRIPT("TestScript"),
        VALUE_SET("ValueSet"),
        VERIFICATION_RESULT("VerificationResult"),
        VISION_PRESCRIPTION("VisionPrescription"),
        PARAMETERS("Parameters");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "Address": {
                    return ADDRESS;
                }
                case "Age": {
                    return AGE;
                }
                case "Annotation": {
                    return ANNOTATION;
                }
                case "Attachment": {
                    return ATTACHMENT;
                }
                case "BackboneElement": {
                    return BACKBONE_ELEMENT;
                }
                case "CodeableConcept": {
                    return CODEABLE_CONCEPT;
                }
                case "CodeableReference": {
                    return CODEABLE_REFERENCE;
                }
                case "Coding": {
                    return CODING;
                }
                case "ContactDetail": {
                    return CONTACT_DETAIL;
                }
                case "ContactPoint": {
                    return CONTACT_POINT;
                }
                case "Contributor": {
                    return CONTRIBUTOR;
                }
                case "Count": {
                    return COUNT;
                }
                case "DataRequirement": {
                    return DATA_REQUIREMENT;
                }
                case "Distance": {
                    return DISTANCE;
                }
                case "Dosage": {
                    return DOSAGE;
                }
                case "Duration": {
                    return DURATION;
                }
                case "Element": {
                    return ELEMENT;
                }
                case "ElementDefinition": {
                    return ELEMENT_DEFINITION;
                }
                case "Expression": {
                    return EXPRESSION;
                }
                case "Extension": {
                    return EXTENSION;
                }
                case "HumanName": {
                    return HUMAN_NAME;
                }
                case "Identifier": {
                    return IDENTIFIER;
                }
                case "MarketingStatus": {
                    return MARKETING_STATUS;
                }
                case "Meta": {
                    return META;
                }
                case "Money": {
                    return MONEY;
                }
                case "MoneyQuantity": {
                    return MONEY_QUANTITY;
                }
                case "Narrative": {
                    return NARRATIVE;
                }
                case "ParameterDefinition": {
                    return PARAMETER_DEFINITION;
                }
                case "Period": {
                    return PERIOD;
                }
                case "Population": {
                    return POPULATION;
                }
                case "ProdCharacteristic": {
                    return PROD_CHARACTERISTIC;
                }
                case "ProductShelfLife": {
                    return PRODUCT_SHELF_LIFE;
                }
                case "Quantity": {
                    return QUANTITY;
                }
                case "Range": {
                    return RANGE;
                }
                case "Ratio": {
                    return RATIO;
                }
                case "RatioRange": {
                    return RATIO_RANGE;
                }
                case "Reference": {
                    return REFERENCE;
                }
                case "RelatedArtifact": {
                    return RELATED_ARTIFACT;
                }
                case "SampledData": {
                    return SAMPLED_DATA;
                }
                case "Signature": {
                    return SIGNATURE;
                }
                case "SimpleQuantity": {
                    return SIMPLE_QUANTITY;
                }
                case "Timing": {
                    return TIMING;
                }
                case "TriggerDefinition": {
                    return TRIGGER_DEFINITION;
                }
                case "UsageContext": {
                    return USAGE_CONTEXT;
                }
                case "base64Binary": {
                    return BASE64BINARY;
                }
                case "boolean": {
                    return BOOLEAN;
                }
                case "canonical": {
                    return CANONICAL;
                }
                case "code": {
                    return CODE;
                }
                case "date": {
                    return DATE;
                }
                case "dateTime": {
                    return DATE_TIME;
                }
                case "decimal": {
                    return DECIMAL;
                }
                case "id": {
                    return ID;
                }
                case "instant": {
                    return INSTANT;
                }
                case "integer": {
                    return INTEGER;
                }
                case "markdown": {
                    return MARKDOWN;
                }
                case "oid": {
                    return OID;
                }
                case "positiveInt": {
                    return POSITIVE_INT;
                }
                case "string": {
                    return STRING;
                }
                case "time": {
                    return TIME;
                }
                case "unsignedInt": {
                    return UNSIGNED_INT;
                }
                case "uri": {
                    return URI;
                }
                case "url": {
                    return URL;
                }
                case "uuid": {
                    return UUID;
                }
                case "xhtml": {
                    return XHTML;
                }
                case "Resource": {
                    return RESOURCE;
                }
                case "Binary": {
                    return BINARY;
                }
                case "Bundle": {
                    return BUNDLE;
                }
                case "DomainResource": {
                    return DOMAIN_RESOURCE;
                }
                case "Account": {
                    return ACCOUNT;
                }
                case "ActivityDefinition": {
                    return ACTIVITY_DEFINITION;
                }
                case "AdministrableProductDefinition": {
                    return ADMINISTRABLE_PRODUCT_DEFINITION;
                }
                case "AdverseEvent": {
                    return ADVERSE_EVENT;
                }
                case "AllergyIntolerance": {
                    return ALLERGY_INTOLERANCE;
                }
                case "Appointment": {
                    return APPOINTMENT;
                }
                case "AppointmentResponse": {
                    return APPOINTMENT_RESPONSE;
                }
                case "AuditEvent": {
                    return AUDIT_EVENT;
                }
                case "Basic": {
                    return BASIC;
                }
                case "BiologicallyDerivedProduct": {
                    return BIOLOGICALLY_DERIVED_PRODUCT;
                }
                case "BodyStructure": {
                    return BODY_STRUCTURE;
                }
                case "CapabilityStatement": {
                    return CAPABILITY_STATEMENT;
                }
                case "CarePlan": {
                    return CARE_PLAN;
                }
                case "CareTeam": {
                    return CARE_TEAM;
                }
                case "CatalogEntry": {
                    return CATALOG_ENTRY;
                }
                case "ChargeItem": {
                    return CHARGE_ITEM;
                }
                case "ChargeItemDefinition": {
                    return CHARGE_ITEM_DEFINITION;
                }
                case "Citation": {
                    return CITATION;
                }
                case "Claim": {
                    return CLAIM;
                }
                case "ClaimResponse": {
                    return CLAIM_RESPONSE;
                }
                case "ClinicalImpression": {
                    return CLINICAL_IMPRESSION;
                }
                case "ClinicalUseDefinition": {
                    return CLINICAL_USE_DEFINITION;
                }
                case "CodeSystem": {
                    return CODE_SYSTEM;
                }
                case "Communication": {
                    return COMMUNICATION;
                }
                case "CommunicationRequest": {
                    return COMMUNICATION_REQUEST;
                }
                case "CompartmentDefinition": {
                    return COMPARTMENT_DEFINITION;
                }
                case "Composition": {
                    return COMPOSITION;
                }
                case "ConceptMap": {
                    return CONCEPT_MAP;
                }
                case "Condition": {
                    return CONDITION;
                }
                case "Consent": {
                    return CONSENT;
                }
                case "Contract": {
                    return CONTRACT;
                }
                case "Coverage": {
                    return COVERAGE;
                }
                case "CoverageEligibilityRequest": {
                    return COVERAGE_ELIGIBILITY_REQUEST;
                }
                case "CoverageEligibilityResponse": {
                    return COVERAGE_ELIGIBILITY_RESPONSE;
                }
                case "DetectedIssue": {
                    return DETECTED_ISSUE;
                }
                case "Device": {
                    return DEVICE;
                }
                case "DeviceDefinition": {
                    return DEVICE_DEFINITION;
                }
                case "DeviceMetric": {
                    return DEVICE_METRIC;
                }
                case "DeviceRequest": {
                    return DEVICE_REQUEST;
                }
                case "DeviceUseStatement": {
                    return DEVICE_USE_STATEMENT;
                }
                case "DiagnosticReport": {
                    return DIAGNOSTIC_REPORT;
                }
                case "DocumentManifest": {
                    return DOCUMENT_MANIFEST;
                }
                case "DocumentReference": {
                    return DOCUMENT_REFERENCE;
                }
                case "Encounter": {
                    return ENCOUNTER;
                }
                case "Endpoint": {
                    return ENDPOINT;
                }
                case "EnrollmentRequest": {
                    return ENROLLMENT_REQUEST;
                }
                case "EnrollmentResponse": {
                    return ENROLLMENT_RESPONSE;
                }
                case "EpisodeOfCare": {
                    return EPISODE_OF_CARE;
                }
                case "EventDefinition": {
                    return EVENT_DEFINITION;
                }
                case "Evidence": {
                    return EVIDENCE;
                }
                case "EvidenceReport": {
                    return EVIDENCE_REPORT;
                }
                case "EvidenceVariable": {
                    return EVIDENCE_VARIABLE;
                }
                case "ExampleScenario": {
                    return EXAMPLE_SCENARIO;
                }
                case "ExplanationOfBenefit": {
                    return EXPLANATION_OF_BENEFIT;
                }
                case "FamilyMemberHistory": {
                    return FAMILY_MEMBER_HISTORY;
                }
                case "Flag": {
                    return FLAG;
                }
                case "Goal": {
                    return GOAL;
                }
                case "GraphDefinition": {
                    return GRAPH_DEFINITION;
                }
                case "Group": {
                    return GROUP;
                }
                case "GuidanceResponse": {
                    return GUIDANCE_RESPONSE;
                }
                case "HealthcareService": {
                    return HEALTHCARE_SERVICE;
                }
                case "ImagingStudy": {
                    return IMAGING_STUDY;
                }
                case "Immunization": {
                    return IMMUNIZATION;
                }
                case "ImmunizationEvaluation": {
                    return IMMUNIZATION_EVALUATION;
                }
                case "ImmunizationRecommendation": {
                    return IMMUNIZATION_RECOMMENDATION;
                }
                case "ImplementationGuide": {
                    return IMPLEMENTATION_GUIDE;
                }
                case "Ingredient": {
                    return INGREDIENT;
                }
                case "InsurancePlan": {
                    return INSURANCE_PLAN;
                }
                case "Invoice": {
                    return INVOICE;
                }
                case "Library": {
                    return LIBRARY;
                }
                case "Linkage": {
                    return LINKAGE;
                }
                case "List": {
                    return LIST;
                }
                case "Location": {
                    return LOCATION;
                }
                case "ManufacturedItemDefinition": {
                    return MANUFACTURED_ITEM_DEFINITION;
                }
                case "Measure": {
                    return MEASURE;
                }
                case "MeasureReport": {
                    return MEASURE_REPORT;
                }
                case "Media": {
                    return MEDIA;
                }
                case "Medication": {
                    return MEDICATION;
                }
                case "MedicationAdministration": {
                    return MEDICATION_ADMINISTRATION;
                }
                case "MedicationDispense": {
                    return MEDICATION_DISPENSE;
                }
                case "MedicationKnowledge": {
                    return MEDICATION_KNOWLEDGE;
                }
                case "MedicationRequest": {
                    return MEDICATION_REQUEST;
                }
                case "MedicationStatement": {
                    return MEDICATION_STATEMENT;
                }
                case "MedicinalProductDefinition": {
                    return MEDICINAL_PRODUCT_DEFINITION;
                }
                case "MessageDefinition": {
                    return MESSAGE_DEFINITION;
                }
                case "MessageHeader": {
                    return MESSAGE_HEADER;
                }
                case "MolecularSequence": {
                    return MOLECULAR_SEQUENCE;
                }
                case "NamingSystem": {
                    return NAMING_SYSTEM;
                }
                case "NutritionOrder": {
                    return NUTRITION_ORDER;
                }
                case "NutritionProduct": {
                    return NUTRITION_PRODUCT;
                }
                case "Observation": {
                    return OBSERVATION;
                }
                case "ObservationDefinition": {
                    return OBSERVATION_DEFINITION;
                }
                case "OperationDefinition": {
                    return OPERATION_DEFINITION;
                }
                case "OperationOutcome": {
                    return OPERATION_OUTCOME;
                }
                case "Organization": {
                    return ORGANIZATION;
                }
                case "OrganizationAffiliation": {
                    return ORGANIZATION_AFFILIATION;
                }
                case "PackagedProductDefinition": {
                    return PACKAGED_PRODUCT_DEFINITION;
                }
                case "Patient": {
                    return PATIENT;
                }
                case "PaymentNotice": {
                    return PAYMENT_NOTICE;
                }
                case "PaymentReconciliation": {
                    return PAYMENT_RECONCILIATION;
                }
                case "Person": {
                    return PERSON;
                }
                case "PlanDefinition": {
                    return PLAN_DEFINITION;
                }
                case "Practitioner": {
                    return PRACTITIONER;
                }
                case "PractitionerRole": {
                    return PRACTITIONER_ROLE;
                }
                case "Procedure": {
                    return PROCEDURE;
                }
                case "Provenance": {
                    return PROVENANCE;
                }
                case "Questionnaire": {
                    return QUESTIONNAIRE;
                }
                case "QuestionnaireResponse": {
                    return QUESTIONNAIRE_RESPONSE;
                }
                case "RegulatedAuthorization": {
                    return REGULATED_AUTHORIZATION;
                }
                case "RelatedPerson": {
                    return RELATED_PERSON;
                }
                case "RequestGroup": {
                    return REQUEST_GROUP;
                }
                case "ResearchDefinition": {
                    return RESEARCH_DEFINITION;
                }
                case "ResearchElementDefinition": {
                    return RESEARCH_ELEMENT_DEFINITION;
                }
                case "ResearchStudy": {
                    return RESEARCH_STUDY;
                }
                case "ResearchSubject": {
                    return RESEARCH_SUBJECT;
                }
                case "RiskAssessment": {
                    return RISK_ASSESSMENT;
                }
                case "Schedule": {
                    return SCHEDULE;
                }
                case "SearchParameter": {
                    return SEARCH_PARAMETER;
                }
                case "ServiceRequest": {
                    return SERVICE_REQUEST;
                }
                case "Slot": {
                    return SLOT;
                }
                case "Specimen": {
                    return SPECIMEN;
                }
                case "SpecimenDefinition": {
                    return SPECIMEN_DEFINITION;
                }
                case "StructureDefinition": {
                    return STRUCTURE_DEFINITION;
                }
                case "StructureMap": {
                    return STRUCTURE_MAP;
                }
                case "Subscription": {
                    return SUBSCRIPTION;
                }
                case "SubscriptionStatus": {
                    return SUBSCRIPTION_STATUS;
                }
                case "SubscriptionTopic": {
                    return SUBSCRIPTION_TOPIC;
                }
                case "Substance": {
                    return SUBSTANCE;
                }
                case "SubstanceDefinition": {
                    return SUBSTANCE_DEFINITION;
                }
                case "SupplyDelivery": {
                    return SUPPLY_DELIVERY;
                }
                case "SupplyRequest": {
                    return SUPPLY_REQUEST;
                }
                case "Task": {
                    return TASK;
                }
                case "TerminologyCapabilities": {
                    return TERMINOLOGY_CAPABILITIES;
                }
                case "TestReport": {
                    return TEST_REPORT;
                }
                case "TestScript": {
                    return TEST_SCRIPT;
                }
                case "ValueSet": {
                    return VALUE_SET;
                }
                case "VerificationResult": {
                    return VERIFICATION_RESULT;
                }
                case "VisionPrescription": {
                    return VISION_PRESCRIPTION;
                }
                case "Parameters": {
                    return PARAMETERS;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public FHIRDefinedType build() {
            FHIRDefinedType fHIRDefinedType = new FHIRDefinedType(this);
            if (this.validating) {
                this.validate(fHIRDefinedType);
            }
            return fHIRDefinedType;
        }

        protected void validate(FHIRDefinedType fHIRDefinedType) {
            super.validate(fHIRDefinedType);
        }

        protected Builder from(FHIRDefinedType fHIRDefinedType) {
            super.from(fHIRDefinedType);
            return this;
        }
    }
}

