/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type.code;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.System;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.String;

@System(value="http://hl7.org/fhir/guidance-response-status")
public class GuidanceResponseStatus
extends Code {
    public static final GuidanceResponseStatus SUCCESS = GuidanceResponseStatus.builder().value(Value.SUCCESS).build();
    public static final GuidanceResponseStatus DATA_REQUESTED = GuidanceResponseStatus.builder().value(Value.DATA_REQUESTED).build();
    public static final GuidanceResponseStatus DATA_REQUIRED = GuidanceResponseStatus.builder().value(Value.DATA_REQUIRED).build();
    public static final GuidanceResponseStatus IN_PROGRESS = GuidanceResponseStatus.builder().value(Value.IN_PROGRESS).build();
    public static final GuidanceResponseStatus FAILURE = GuidanceResponseStatus.builder().value(Value.FAILURE).build();
    public static final GuidanceResponseStatus ENTERED_IN_ERROR = GuidanceResponseStatus.builder().value(Value.ENTERED_IN_ERROR).build();
    private volatile int hashCode;

    private GuidanceResponseStatus(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static GuidanceResponseStatus of(Value value) {
        switch (value) {
            case SUCCESS: {
                return SUCCESS;
            }
            case DATA_REQUESTED: {
                return DATA_REQUESTED;
            }
            case DATA_REQUIRED: {
                return DATA_REQUIRED;
            }
            case IN_PROGRESS: {
                return IN_PROGRESS;
            }
            case FAILURE: {
                return FAILURE;
            }
            case ENTERED_IN_ERROR: {
                return ENTERED_IN_ERROR;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static GuidanceResponseStatus of(java.lang.String value) {
        return GuidanceResponseStatus.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return GuidanceResponseStatus.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return GuidanceResponseStatus.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GuidanceResponseStatus other = (GuidanceResponseStatus)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        SUCCESS("success"),
        DATA_REQUESTED("data-requested"),
        DATA_REQUIRED("data-required"),
        IN_PROGRESS("in-progress"),
        FAILURE("failure"),
        ENTERED_IN_ERROR("entered-in-error");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "success": {
                    return SUCCESS;
                }
                case "data-requested": {
                    return DATA_REQUESTED;
                }
                case "data-required": {
                    return DATA_REQUIRED;
                }
                case "in-progress": {
                    return IN_PROGRESS;
                }
                case "failure": {
                    return FAILURE;
                }
                case "entered-in-error": {
                    return ENTERED_IN_ERROR;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public GuidanceResponseStatus build() {
            GuidanceResponseStatus guidanceResponseStatus = new GuidanceResponseStatus(this);
            if (this.validating) {
                this.validate(guidanceResponseStatus);
            }
            return guidanceResponseStatus;
        }

        protected void validate(GuidanceResponseStatus guidanceResponseStatus) {
            super.validate(guidanceResponseStatus);
        }

        protected Builder from(GuidanceResponseStatus guidanceResponseStatus) {
            super.from(guidanceResponseStatus);
            return this;
        }
    }
}

