/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type.code;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.System;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.String;

@System(value="http://hl7.org/fhir/guide-parameter-code")
public class GuideParameterCode
extends Code {
    public static final GuideParameterCode APPLY = GuideParameterCode.builder().value(Value.APPLY).build();
    public static final GuideParameterCode PATH_RESOURCE = GuideParameterCode.builder().value(Value.PATH_RESOURCE).build();
    public static final GuideParameterCode PATH_PAGES = GuideParameterCode.builder().value(Value.PATH_PAGES).build();
    public static final GuideParameterCode PATH_TX_CACHE = GuideParameterCode.builder().value(Value.PATH_TX_CACHE).build();
    public static final GuideParameterCode EXPANSION_PARAMETER = GuideParameterCode.builder().value(Value.EXPANSION_PARAMETER).build();
    public static final GuideParameterCode RULE_BROKEN_LINKS = GuideParameterCode.builder().value(Value.RULE_BROKEN_LINKS).build();
    public static final GuideParameterCode GENERATE_XML = GuideParameterCode.builder().value(Value.GENERATE_XML).build();
    public static final GuideParameterCode GENERATE_JSON = GuideParameterCode.builder().value(Value.GENERATE_JSON).build();
    public static final GuideParameterCode GENERATE_TURTLE = GuideParameterCode.builder().value(Value.GENERATE_TURTLE).build();
    public static final GuideParameterCode HTML_TEMPLATE = GuideParameterCode.builder().value(Value.HTML_TEMPLATE).build();
    private volatile int hashCode;

    private GuideParameterCode(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static GuideParameterCode of(Value value) {
        switch (value) {
            case APPLY: {
                return APPLY;
            }
            case PATH_RESOURCE: {
                return PATH_RESOURCE;
            }
            case PATH_PAGES: {
                return PATH_PAGES;
            }
            case PATH_TX_CACHE: {
                return PATH_TX_CACHE;
            }
            case EXPANSION_PARAMETER: {
                return EXPANSION_PARAMETER;
            }
            case RULE_BROKEN_LINKS: {
                return RULE_BROKEN_LINKS;
            }
            case GENERATE_XML: {
                return GENERATE_XML;
            }
            case GENERATE_JSON: {
                return GENERATE_JSON;
            }
            case GENERATE_TURTLE: {
                return GENERATE_TURTLE;
            }
            case HTML_TEMPLATE: {
                return HTML_TEMPLATE;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static GuideParameterCode of(java.lang.String value) {
        return GuideParameterCode.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return GuideParameterCode.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return GuideParameterCode.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GuideParameterCode other = (GuideParameterCode)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        APPLY("apply"),
        PATH_RESOURCE("path-resource"),
        PATH_PAGES("path-pages"),
        PATH_TX_CACHE("path-tx-cache"),
        EXPANSION_PARAMETER("expansion-parameter"),
        RULE_BROKEN_LINKS("rule-broken-links"),
        GENERATE_XML("generate-xml"),
        GENERATE_JSON("generate-json"),
        GENERATE_TURTLE("generate-turtle"),
        HTML_TEMPLATE("html-template");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "apply": {
                    return APPLY;
                }
                case "path-resource": {
                    return PATH_RESOURCE;
                }
                case "path-pages": {
                    return PATH_PAGES;
                }
                case "path-tx-cache": {
                    return PATH_TX_CACHE;
                }
                case "expansion-parameter": {
                    return EXPANSION_PARAMETER;
                }
                case "rule-broken-links": {
                    return RULE_BROKEN_LINKS;
                }
                case "generate-xml": {
                    return GENERATE_XML;
                }
                case "generate-json": {
                    return GENERATE_JSON;
                }
                case "generate-turtle": {
                    return GENERATE_TURTLE;
                }
                case "html-template": {
                    return HTML_TEMPLATE;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public GuideParameterCode build() {
            GuideParameterCode guideParameterCode = new GuideParameterCode(this);
            if (this.validating) {
                this.validate(guideParameterCode);
            }
            return guideParameterCode;
        }

        protected void validate(GuideParameterCode guideParameterCode) {
            super.validate(guideParameterCode);
        }

        protected Builder from(GuideParameterCode guideParameterCode) {
            super.from(guideParameterCode);
            return this;
        }
    }
}

