/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type.code;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.System;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.String;

@System(value="http://hl7.org/fhir/imagingstudy-status")
public class ImagingStudyStatus
extends Code {
    public static final ImagingStudyStatus REGISTERED = ImagingStudyStatus.builder().value(Value.REGISTERED).build();
    public static final ImagingStudyStatus AVAILABLE = ImagingStudyStatus.builder().value(Value.AVAILABLE).build();
    public static final ImagingStudyStatus CANCELLED = ImagingStudyStatus.builder().value(Value.CANCELLED).build();
    public static final ImagingStudyStatus ENTERED_IN_ERROR = ImagingStudyStatus.builder().value(Value.ENTERED_IN_ERROR).build();
    public static final ImagingStudyStatus UNKNOWN = ImagingStudyStatus.builder().value(Value.UNKNOWN).build();
    private volatile int hashCode;

    private ImagingStudyStatus(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static ImagingStudyStatus of(Value value) {
        switch (value) {
            case REGISTERED: {
                return REGISTERED;
            }
            case AVAILABLE: {
                return AVAILABLE;
            }
            case CANCELLED: {
                return CANCELLED;
            }
            case ENTERED_IN_ERROR: {
                return ENTERED_IN_ERROR;
            }
            case UNKNOWN: {
                return UNKNOWN;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static ImagingStudyStatus of(java.lang.String value) {
        return ImagingStudyStatus.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return ImagingStudyStatus.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return ImagingStudyStatus.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImagingStudyStatus other = (ImagingStudyStatus)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        REGISTERED("registered"),
        AVAILABLE("available"),
        CANCELLED("cancelled"),
        ENTERED_IN_ERROR("entered-in-error"),
        UNKNOWN("unknown");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "registered": {
                    return REGISTERED;
                }
                case "available": {
                    return AVAILABLE;
                }
                case "cancelled": {
                    return CANCELLED;
                }
                case "entered-in-error": {
                    return ENTERED_IN_ERROR;
                }
                case "unknown": {
                    return UNKNOWN;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public ImagingStudyStatus build() {
            ImagingStudyStatus imagingStudyStatus = new ImagingStudyStatus(this);
            if (this.validating) {
                this.validate(imagingStudyStatus);
            }
            return imagingStudyStatus;
        }

        protected void validate(ImagingStudyStatus imagingStudyStatus) {
            super.validate(imagingStudyStatus);
        }

        protected Builder from(ImagingStudyStatus imagingStudyStatus) {
            super.from(imagingStudyStatus);
            return this;
        }
    }
}

