/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type.code;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.System;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.String;

@System(value="http://terminology.hl7.org/CodeSystem/medicationdispense-status")
public class MedicationDispenseStatus
extends Code {
    public static final MedicationDispenseStatus PREPARATION = MedicationDispenseStatus.builder().value(Value.PREPARATION).build();
    public static final MedicationDispenseStatus IN_PROGRESS = MedicationDispenseStatus.builder().value(Value.IN_PROGRESS).build();
    public static final MedicationDispenseStatus CANCELLED = MedicationDispenseStatus.builder().value(Value.CANCELLED).build();
    public static final MedicationDispenseStatus ON_HOLD = MedicationDispenseStatus.builder().value(Value.ON_HOLD).build();
    public static final MedicationDispenseStatus COMPLETED = MedicationDispenseStatus.builder().value(Value.COMPLETED).build();
    public static final MedicationDispenseStatus ENTERED_IN_ERROR = MedicationDispenseStatus.builder().value(Value.ENTERED_IN_ERROR).build();
    public static final MedicationDispenseStatus STOPPED = MedicationDispenseStatus.builder().value(Value.STOPPED).build();
    public static final MedicationDispenseStatus DECLINED = MedicationDispenseStatus.builder().value(Value.DECLINED).build();
    public static final MedicationDispenseStatus UNKNOWN = MedicationDispenseStatus.builder().value(Value.UNKNOWN).build();
    private volatile int hashCode;

    private MedicationDispenseStatus(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static MedicationDispenseStatus of(Value value) {
        switch (value) {
            case PREPARATION: {
                return PREPARATION;
            }
            case IN_PROGRESS: {
                return IN_PROGRESS;
            }
            case CANCELLED: {
                return CANCELLED;
            }
            case ON_HOLD: {
                return ON_HOLD;
            }
            case COMPLETED: {
                return COMPLETED;
            }
            case ENTERED_IN_ERROR: {
                return ENTERED_IN_ERROR;
            }
            case STOPPED: {
                return STOPPED;
            }
            case DECLINED: {
                return DECLINED;
            }
            case UNKNOWN: {
                return UNKNOWN;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static MedicationDispenseStatus of(java.lang.String value) {
        return MedicationDispenseStatus.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return MedicationDispenseStatus.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return MedicationDispenseStatus.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MedicationDispenseStatus other = (MedicationDispenseStatus)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        PREPARATION("preparation"),
        IN_PROGRESS("in-progress"),
        CANCELLED("cancelled"),
        ON_HOLD("on-hold"),
        COMPLETED("completed"),
        ENTERED_IN_ERROR("entered-in-error"),
        STOPPED("stopped"),
        DECLINED("declined"),
        UNKNOWN("unknown");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "preparation": {
                    return PREPARATION;
                }
                case "in-progress": {
                    return IN_PROGRESS;
                }
                case "cancelled": {
                    return CANCELLED;
                }
                case "on-hold": {
                    return ON_HOLD;
                }
                case "completed": {
                    return COMPLETED;
                }
                case "entered-in-error": {
                    return ENTERED_IN_ERROR;
                }
                case "stopped": {
                    return STOPPED;
                }
                case "declined": {
                    return DECLINED;
                }
                case "unknown": {
                    return UNKNOWN;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public MedicationDispenseStatus build() {
            MedicationDispenseStatus medicationDispenseStatus = new MedicationDispenseStatus(this);
            if (this.validating) {
                this.validate(medicationDispenseStatus);
            }
            return medicationDispenseStatus;
        }

        protected void validate(MedicationDispenseStatus medicationDispenseStatus) {
            super.validate(medicationDispenseStatus);
        }

        protected Builder from(MedicationDispenseStatus medicationDispenseStatus) {
            super.from(medicationDispenseStatus);
            return this;
        }
    }
}

