/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type.code;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.System;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.String;

@System(value="http://hl7.org/fhir/CodeSystem/medicationrequest-intent")
public class MedicationRequestIntent
extends Code {
    public static final MedicationRequestIntent PROPOSAL = MedicationRequestIntent.builder().value(Value.PROPOSAL).build();
    public static final MedicationRequestIntent PLAN = MedicationRequestIntent.builder().value(Value.PLAN).build();
    public static final MedicationRequestIntent ORDER = MedicationRequestIntent.builder().value(Value.ORDER).build();
    public static final MedicationRequestIntent ORIGINAL_ORDER = MedicationRequestIntent.builder().value(Value.ORIGINAL_ORDER).build();
    public static final MedicationRequestIntent REFLEX_ORDER = MedicationRequestIntent.builder().value(Value.REFLEX_ORDER).build();
    public static final MedicationRequestIntent FILLER_ORDER = MedicationRequestIntent.builder().value(Value.FILLER_ORDER).build();
    public static final MedicationRequestIntent INSTANCE_ORDER = MedicationRequestIntent.builder().value(Value.INSTANCE_ORDER).build();
    public static final MedicationRequestIntent OPTION = MedicationRequestIntent.builder().value(Value.OPTION).build();
    private volatile int hashCode;

    private MedicationRequestIntent(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static MedicationRequestIntent of(Value value) {
        switch (value) {
            case PROPOSAL: {
                return PROPOSAL;
            }
            case PLAN: {
                return PLAN;
            }
            case ORDER: {
                return ORDER;
            }
            case ORIGINAL_ORDER: {
                return ORIGINAL_ORDER;
            }
            case REFLEX_ORDER: {
                return REFLEX_ORDER;
            }
            case FILLER_ORDER: {
                return FILLER_ORDER;
            }
            case INSTANCE_ORDER: {
                return INSTANCE_ORDER;
            }
            case OPTION: {
                return OPTION;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static MedicationRequestIntent of(java.lang.String value) {
        return MedicationRequestIntent.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return MedicationRequestIntent.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return MedicationRequestIntent.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MedicationRequestIntent other = (MedicationRequestIntent)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        PROPOSAL("proposal"),
        PLAN("plan"),
        ORDER("order"),
        ORIGINAL_ORDER("original-order"),
        REFLEX_ORDER("reflex-order"),
        FILLER_ORDER("filler-order"),
        INSTANCE_ORDER("instance-order"),
        OPTION("option");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "proposal": {
                    return PROPOSAL;
                }
                case "plan": {
                    return PLAN;
                }
                case "order": {
                    return ORDER;
                }
                case "original-order": {
                    return ORIGINAL_ORDER;
                }
                case "reflex-order": {
                    return REFLEX_ORDER;
                }
                case "filler-order": {
                    return FILLER_ORDER;
                }
                case "instance-order": {
                    return INSTANCE_ORDER;
                }
                case "option": {
                    return OPTION;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public MedicationRequestIntent build() {
            MedicationRequestIntent medicationRequestIntent = new MedicationRequestIntent(this);
            if (this.validating) {
                this.validate(medicationRequestIntent);
            }
            return medicationRequestIntent;
        }

        protected void validate(MedicationRequestIntent medicationRequestIntent) {
            super.validate(medicationRequestIntent);
        }

        protected Builder from(MedicationRequestIntent medicationRequestIntent) {
            super.from(medicationRequestIntent);
            return this;
        }
    }
}

