/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type.code;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.System;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.String;

@System(value="http://hl7.org/fhir/CodeSystem/medicationrequest-status")
public class MedicationRequestStatus
extends Code {
    public static final MedicationRequestStatus ACTIVE = MedicationRequestStatus.builder().value(Value.ACTIVE).build();
    public static final MedicationRequestStatus ON_HOLD = MedicationRequestStatus.builder().value(Value.ON_HOLD).build();
    public static final MedicationRequestStatus CANCELLED = MedicationRequestStatus.builder().value(Value.CANCELLED).build();
    public static final MedicationRequestStatus COMPLETED = MedicationRequestStatus.builder().value(Value.COMPLETED).build();
    public static final MedicationRequestStatus ENTERED_IN_ERROR = MedicationRequestStatus.builder().value(Value.ENTERED_IN_ERROR).build();
    public static final MedicationRequestStatus STOPPED = MedicationRequestStatus.builder().value(Value.STOPPED).build();
    public static final MedicationRequestStatus DRAFT = MedicationRequestStatus.builder().value(Value.DRAFT).build();
    public static final MedicationRequestStatus UNKNOWN = MedicationRequestStatus.builder().value(Value.UNKNOWN).build();
    private volatile int hashCode;

    private MedicationRequestStatus(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static MedicationRequestStatus of(Value value) {
        switch (value) {
            case ACTIVE: {
                return ACTIVE;
            }
            case ON_HOLD: {
                return ON_HOLD;
            }
            case CANCELLED: {
                return CANCELLED;
            }
            case COMPLETED: {
                return COMPLETED;
            }
            case ENTERED_IN_ERROR: {
                return ENTERED_IN_ERROR;
            }
            case STOPPED: {
                return STOPPED;
            }
            case DRAFT: {
                return DRAFT;
            }
            case UNKNOWN: {
                return UNKNOWN;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static MedicationRequestStatus of(java.lang.String value) {
        return MedicationRequestStatus.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return MedicationRequestStatus.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return MedicationRequestStatus.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MedicationRequestStatus other = (MedicationRequestStatus)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        ACTIVE("active"),
        ON_HOLD("on-hold"),
        CANCELLED("cancelled"),
        COMPLETED("completed"),
        ENTERED_IN_ERROR("entered-in-error"),
        STOPPED("stopped"),
        DRAFT("draft"),
        UNKNOWN("unknown");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "active": {
                    return ACTIVE;
                }
                case "on-hold": {
                    return ON_HOLD;
                }
                case "cancelled": {
                    return CANCELLED;
                }
                case "completed": {
                    return COMPLETED;
                }
                case "entered-in-error": {
                    return ENTERED_IN_ERROR;
                }
                case "stopped": {
                    return STOPPED;
                }
                case "draft": {
                    return DRAFT;
                }
                case "unknown": {
                    return UNKNOWN;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public MedicationRequestStatus build() {
            MedicationRequestStatus medicationRequestStatus = new MedicationRequestStatus(this);
            if (this.validating) {
                this.validate(medicationRequestStatus);
            }
            return medicationRequestStatus;
        }

        protected void validate(MedicationRequestStatus medicationRequestStatus) {
            super.validate(medicationRequestStatus);
        }

        protected Builder from(MedicationRequestStatus medicationRequestStatus) {
            super.from(medicationRequestStatus);
            return this;
        }
    }
}

