/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type.code;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.System;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.String;

@System(value="http://hl7.org/fhir/observation-range-category")
public class ObservationRangeCategory
extends Code {
    public static final ObservationRangeCategory REFERENCE = ObservationRangeCategory.builder().value(Value.REFERENCE).build();
    public static final ObservationRangeCategory CRITICAL = ObservationRangeCategory.builder().value(Value.CRITICAL).build();
    public static final ObservationRangeCategory ABSOLUTE = ObservationRangeCategory.builder().value(Value.ABSOLUTE).build();
    private volatile int hashCode;

    private ObservationRangeCategory(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static ObservationRangeCategory of(Value value) {
        switch (value) {
            case REFERENCE: {
                return REFERENCE;
            }
            case CRITICAL: {
                return CRITICAL;
            }
            case ABSOLUTE: {
                return ABSOLUTE;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static ObservationRangeCategory of(java.lang.String value) {
        return ObservationRangeCategory.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return ObservationRangeCategory.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return ObservationRangeCategory.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ObservationRangeCategory other = (ObservationRangeCategory)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        REFERENCE("reference"),
        CRITICAL("critical"),
        ABSOLUTE("absolute");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "reference": {
                    return REFERENCE;
                }
                case "critical": {
                    return CRITICAL;
                }
                case "absolute": {
                    return ABSOLUTE;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public ObservationRangeCategory build() {
            ObservationRangeCategory observationRangeCategory = new ObservationRangeCategory(this);
            if (this.validating) {
                this.validate(observationRangeCategory);
            }
            return observationRangeCategory;
        }

        protected void validate(ObservationRangeCategory observationRangeCategory) {
            super.validate(observationRangeCategory);
        }

        protected Builder from(ObservationRangeCategory observationRangeCategory) {
            super.from(observationRangeCategory);
            return this;
        }
    }
}

