/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type.code;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.System;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.String;

@System(value="http://hl7.org/fhir/observation-status")
public class ObservationStatus
extends Code {
    public static final ObservationStatus REGISTERED = ObservationStatus.builder().value(Value.REGISTERED).build();
    public static final ObservationStatus PRELIMINARY = ObservationStatus.builder().value(Value.PRELIMINARY).build();
    public static final ObservationStatus FINAL = ObservationStatus.builder().value(Value.FINAL).build();
    public static final ObservationStatus AMENDED = ObservationStatus.builder().value(Value.AMENDED).build();
    public static final ObservationStatus CORRECTED = ObservationStatus.builder().value(Value.CORRECTED).build();
    public static final ObservationStatus CANCELLED = ObservationStatus.builder().value(Value.CANCELLED).build();
    public static final ObservationStatus ENTERED_IN_ERROR = ObservationStatus.builder().value(Value.ENTERED_IN_ERROR).build();
    public static final ObservationStatus UNKNOWN = ObservationStatus.builder().value(Value.UNKNOWN).build();
    private volatile int hashCode;

    private ObservationStatus(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static ObservationStatus of(Value value) {
        switch (value) {
            case REGISTERED: {
                return REGISTERED;
            }
            case PRELIMINARY: {
                return PRELIMINARY;
            }
            case FINAL: {
                return FINAL;
            }
            case AMENDED: {
                return AMENDED;
            }
            case CORRECTED: {
                return CORRECTED;
            }
            case CANCELLED: {
                return CANCELLED;
            }
            case ENTERED_IN_ERROR: {
                return ENTERED_IN_ERROR;
            }
            case UNKNOWN: {
                return UNKNOWN;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static ObservationStatus of(java.lang.String value) {
        return ObservationStatus.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return ObservationStatus.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return ObservationStatus.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ObservationStatus other = (ObservationStatus)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        REGISTERED("registered"),
        PRELIMINARY("preliminary"),
        FINAL("final"),
        AMENDED("amended"),
        CORRECTED("corrected"),
        CANCELLED("cancelled"),
        ENTERED_IN_ERROR("entered-in-error"),
        UNKNOWN("unknown");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "registered": {
                    return REGISTERED;
                }
                case "preliminary": {
                    return PRELIMINARY;
                }
                case "final": {
                    return FINAL;
                }
                case "amended": {
                    return AMENDED;
                }
                case "corrected": {
                    return CORRECTED;
                }
                case "cancelled": {
                    return CANCELLED;
                }
                case "entered-in-error": {
                    return ENTERED_IN_ERROR;
                }
                case "unknown": {
                    return UNKNOWN;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public ObservationStatus build() {
            ObservationStatus observationStatus = new ObservationStatus(this);
            if (this.validating) {
                this.validate(observationStatus);
            }
            return observationStatus;
        }

        protected void validate(ObservationStatus observationStatus) {
            super.validate(observationStatus);
        }

        protected Builder from(ObservationStatus observationStatus) {
            super.from(observationStatus);
            return this;
        }
    }
}

