/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type.code;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.System;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.String;

@System(value="http://hl7.org/fhir/questionnaire-enable-operator")
public class QuestionnaireItemOperator
extends Code {
    public static final QuestionnaireItemOperator EXISTS = QuestionnaireItemOperator.builder().value(Value.EXISTS).build();
    public static final QuestionnaireItemOperator EQUALS = QuestionnaireItemOperator.builder().value(Value.EQUALS).build();
    public static final QuestionnaireItemOperator NOT_EQUALS = QuestionnaireItemOperator.builder().value(Value.NOT_EQUALS).build();
    public static final QuestionnaireItemOperator GREATER_THAN = QuestionnaireItemOperator.builder().value(Value.GREATER_THAN).build();
    public static final QuestionnaireItemOperator LESS_THAN = QuestionnaireItemOperator.builder().value(Value.LESS_THAN).build();
    public static final QuestionnaireItemOperator GREATER_OR_EQUALS = QuestionnaireItemOperator.builder().value(Value.GREATER_OR_EQUALS).build();
    public static final QuestionnaireItemOperator LESS_OR_EQUALS = QuestionnaireItemOperator.builder().value(Value.LESS_OR_EQUALS).build();
    private volatile int hashCode;

    private QuestionnaireItemOperator(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static QuestionnaireItemOperator of(Value value) {
        switch (value) {
            case EXISTS: {
                return EXISTS;
            }
            case EQUALS: {
                return EQUALS;
            }
            case NOT_EQUALS: {
                return NOT_EQUALS;
            }
            case GREATER_THAN: {
                return GREATER_THAN;
            }
            case LESS_THAN: {
                return LESS_THAN;
            }
            case GREATER_OR_EQUALS: {
                return GREATER_OR_EQUALS;
            }
            case LESS_OR_EQUALS: {
                return LESS_OR_EQUALS;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static QuestionnaireItemOperator of(java.lang.String value) {
        return QuestionnaireItemOperator.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return QuestionnaireItemOperator.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return QuestionnaireItemOperator.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QuestionnaireItemOperator other = (QuestionnaireItemOperator)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        EXISTS("exists"),
        EQUALS("="),
        NOT_EQUALS("!="),
        GREATER_THAN(">"),
        LESS_THAN("<"),
        GREATER_OR_EQUALS(">="),
        LESS_OR_EQUALS("<=");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "exists": {
                    return EXISTS;
                }
                case "=": {
                    return EQUALS;
                }
                case "!=": {
                    return NOT_EQUALS;
                }
                case ">": {
                    return GREATER_THAN;
                }
                case "<": {
                    return LESS_THAN;
                }
                case ">=": {
                    return GREATER_OR_EQUALS;
                }
                case "<=": {
                    return LESS_OR_EQUALS;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public QuestionnaireItemOperator build() {
            QuestionnaireItemOperator questionnaireItemOperator = new QuestionnaireItemOperator(this);
            if (this.validating) {
                this.validate(questionnaireItemOperator);
            }
            return questionnaireItemOperator;
        }

        protected void validate(QuestionnaireItemOperator questionnaireItemOperator) {
            super.validate(questionnaireItemOperator);
        }

        protected Builder from(QuestionnaireItemOperator questionnaireItemOperator) {
            super.from(questionnaireItemOperator);
            return this;
        }
    }
}

