/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type.code;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.System;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.String;

@System(value="http://hl7.org/fhir/questionnaire-answers-status")
public class QuestionnaireResponseStatus
extends Code {
    public static final QuestionnaireResponseStatus IN_PROGRESS = QuestionnaireResponseStatus.builder().value(Value.IN_PROGRESS).build();
    public static final QuestionnaireResponseStatus COMPLETED = QuestionnaireResponseStatus.builder().value(Value.COMPLETED).build();
    public static final QuestionnaireResponseStatus AMENDED = QuestionnaireResponseStatus.builder().value(Value.AMENDED).build();
    public static final QuestionnaireResponseStatus ENTERED_IN_ERROR = QuestionnaireResponseStatus.builder().value(Value.ENTERED_IN_ERROR).build();
    public static final QuestionnaireResponseStatus STOPPED = QuestionnaireResponseStatus.builder().value(Value.STOPPED).build();
    private volatile int hashCode;

    private QuestionnaireResponseStatus(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static QuestionnaireResponseStatus of(Value value) {
        switch (value) {
            case IN_PROGRESS: {
                return IN_PROGRESS;
            }
            case COMPLETED: {
                return COMPLETED;
            }
            case AMENDED: {
                return AMENDED;
            }
            case ENTERED_IN_ERROR: {
                return ENTERED_IN_ERROR;
            }
            case STOPPED: {
                return STOPPED;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static QuestionnaireResponseStatus of(java.lang.String value) {
        return QuestionnaireResponseStatus.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return QuestionnaireResponseStatus.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return QuestionnaireResponseStatus.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QuestionnaireResponseStatus other = (QuestionnaireResponseStatus)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        IN_PROGRESS("in-progress"),
        COMPLETED("completed"),
        AMENDED("amended"),
        ENTERED_IN_ERROR("entered-in-error"),
        STOPPED("stopped");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "in-progress": {
                    return IN_PROGRESS;
                }
                case "completed": {
                    return COMPLETED;
                }
                case "amended": {
                    return AMENDED;
                }
                case "entered-in-error": {
                    return ENTERED_IN_ERROR;
                }
                case "stopped": {
                    return STOPPED;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public QuestionnaireResponseStatus build() {
            QuestionnaireResponseStatus questionnaireResponseStatus = new QuestionnaireResponseStatus(this);
            if (this.validating) {
                this.validate(questionnaireResponseStatus);
            }
            return questionnaireResponseStatus;
        }

        protected void validate(QuestionnaireResponseStatus questionnaireResponseStatus) {
            super.validate(questionnaireResponseStatus);
        }

        protected Builder from(QuestionnaireResponseStatus questionnaireResponseStatus) {
            super.from(questionnaireResponseStatus);
            return this;
        }
    }
}

