/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type.code;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.System;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.String;

@System(value="http://hl7.org/fhir/composition-status")
public class ReferredDocumentStatus
extends Code {
    public static final ReferredDocumentStatus PRELIMINARY = ReferredDocumentStatus.builder().value(Value.PRELIMINARY).build();
    public static final ReferredDocumentStatus FINAL = ReferredDocumentStatus.builder().value(Value.FINAL).build();
    public static final ReferredDocumentStatus AMENDED = ReferredDocumentStatus.builder().value(Value.AMENDED).build();
    public static final ReferredDocumentStatus ENTERED_IN_ERROR = ReferredDocumentStatus.builder().value(Value.ENTERED_IN_ERROR).build();
    private volatile int hashCode;

    private ReferredDocumentStatus(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static ReferredDocumentStatus of(Value value) {
        switch (value) {
            case PRELIMINARY: {
                return PRELIMINARY;
            }
            case FINAL: {
                return FINAL;
            }
            case AMENDED: {
                return AMENDED;
            }
            case ENTERED_IN_ERROR: {
                return ENTERED_IN_ERROR;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static ReferredDocumentStatus of(java.lang.String value) {
        return ReferredDocumentStatus.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return ReferredDocumentStatus.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return ReferredDocumentStatus.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReferredDocumentStatus other = (ReferredDocumentStatus)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        PRELIMINARY("preliminary"),
        FINAL("final"),
        AMENDED("amended"),
        ENTERED_IN_ERROR("entered-in-error");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "preliminary": {
                    return PRELIMINARY;
                }
                case "final": {
                    return FINAL;
                }
                case "amended": {
                    return AMENDED;
                }
                case "entered-in-error": {
                    return ENTERED_IN_ERROR;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public ReferredDocumentStatus build() {
            ReferredDocumentStatus referredDocumentStatus = new ReferredDocumentStatus(this);
            if (this.validating) {
                this.validate(referredDocumentStatus);
            }
            return referredDocumentStatus;
        }

        protected void validate(ReferredDocumentStatus referredDocumentStatus) {
            super.validate(referredDocumentStatus);
        }

        protected Builder from(ReferredDocumentStatus referredDocumentStatus) {
            super.from(referredDocumentStatus);
            return this;
        }
    }
}

