/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type.code;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.System;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.String;

@System(value="http://hl7.org/fhir/report-relation-type")
public class ReportRelationshipType
extends Code {
    public static final ReportRelationshipType REPLACES = ReportRelationshipType.builder().value(Value.REPLACES).build();
    public static final ReportRelationshipType AMENDS = ReportRelationshipType.builder().value(Value.AMENDS).build();
    public static final ReportRelationshipType APPENDS = ReportRelationshipType.builder().value(Value.APPENDS).build();
    public static final ReportRelationshipType TRANSFORMS = ReportRelationshipType.builder().value(Value.TRANSFORMS).build();
    public static final ReportRelationshipType REPLACED_WITH = ReportRelationshipType.builder().value(Value.REPLACED_WITH).build();
    public static final ReportRelationshipType AMENDED_WITH = ReportRelationshipType.builder().value(Value.AMENDED_WITH).build();
    public static final ReportRelationshipType APPENDED_WITH = ReportRelationshipType.builder().value(Value.APPENDED_WITH).build();
    public static final ReportRelationshipType TRANSFORMED_WITH = ReportRelationshipType.builder().value(Value.TRANSFORMED_WITH).build();
    private volatile int hashCode;

    private ReportRelationshipType(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static ReportRelationshipType of(Value value) {
        switch (value) {
            case REPLACES: {
                return REPLACES;
            }
            case AMENDS: {
                return AMENDS;
            }
            case APPENDS: {
                return APPENDS;
            }
            case TRANSFORMS: {
                return TRANSFORMS;
            }
            case REPLACED_WITH: {
                return REPLACED_WITH;
            }
            case AMENDED_WITH: {
                return AMENDED_WITH;
            }
            case APPENDED_WITH: {
                return APPENDED_WITH;
            }
            case TRANSFORMED_WITH: {
                return TRANSFORMED_WITH;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static ReportRelationshipType of(java.lang.String value) {
        return ReportRelationshipType.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return ReportRelationshipType.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return ReportRelationshipType.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReportRelationshipType other = (ReportRelationshipType)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        REPLACES("replaces"),
        AMENDS("amends"),
        APPENDS("appends"),
        TRANSFORMS("transforms"),
        REPLACED_WITH("replacedWith"),
        AMENDED_WITH("amendedWith"),
        APPENDED_WITH("appendedWith"),
        TRANSFORMED_WITH("transformedWith");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "replaces": {
                    return REPLACES;
                }
                case "amends": {
                    return AMENDS;
                }
                case "appends": {
                    return APPENDS;
                }
                case "transforms": {
                    return TRANSFORMS;
                }
                case "replacedWith": {
                    return REPLACED_WITH;
                }
                case "amendedWith": {
                    return AMENDED_WITH;
                }
                case "appendedWith": {
                    return APPENDED_WITH;
                }
                case "transformedWith": {
                    return TRANSFORMED_WITH;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public ReportRelationshipType build() {
            ReportRelationshipType reportRelationshipType = new ReportRelationshipType(this);
            if (this.validating) {
                this.validate(reportRelationshipType);
            }
            return reportRelationshipType;
        }

        protected void validate(ReportRelationshipType reportRelationshipType) {
            super.validate(reportRelationshipType);
        }

        protected Builder from(ReportRelationshipType reportRelationshipType) {
            super.from(reportRelationshipType);
            return this;
        }
    }
}

