/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type.code;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.System;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.String;

@System(value="http://hl7.org/fhir/request-priority")
public class RequestPriority
extends Code {
    public static final RequestPriority ROUTINE = RequestPriority.builder().value(Value.ROUTINE).build();
    public static final RequestPriority URGENT = RequestPriority.builder().value(Value.URGENT).build();
    public static final RequestPriority ASAP = RequestPriority.builder().value(Value.ASAP).build();
    public static final RequestPriority STAT = RequestPriority.builder().value(Value.STAT).build();
    private volatile int hashCode;

    private RequestPriority(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static RequestPriority of(Value value) {
        switch (value) {
            case ROUTINE: {
                return ROUTINE;
            }
            case URGENT: {
                return URGENT;
            }
            case ASAP: {
                return ASAP;
            }
            case STAT: {
                return STAT;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static RequestPriority of(java.lang.String value) {
        return RequestPriority.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return RequestPriority.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return RequestPriority.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequestPriority other = (RequestPriority)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        ROUTINE("routine"),
        URGENT("urgent"),
        ASAP("asap"),
        STAT("stat");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "routine": {
                    return ROUTINE;
                }
                case "urgent": {
                    return URGENT;
                }
                case "asap": {
                    return ASAP;
                }
                case "stat": {
                    return STAT;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public RequestPriority build() {
            RequestPriority requestPriority = new RequestPriority(this);
            if (this.validating) {
                this.validate(requestPriority);
            }
            return requestPriority;
        }

        protected void validate(RequestPriority requestPriority) {
            super.validate(requestPriority);
        }

        protected Builder from(RequestPriority requestPriority) {
            super.from(requestPriority);
            return this;
        }
    }
}

