/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type.code;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.System;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.String;

@System(value="http://hl7.org/fhir/versioning-policy")
public class ResourceVersionPolicy
extends Code {
    public static final ResourceVersionPolicy NO_VERSION = ResourceVersionPolicy.builder().value(Value.NO_VERSION).build();
    public static final ResourceVersionPolicy VERSIONED = ResourceVersionPolicy.builder().value(Value.VERSIONED).build();
    public static final ResourceVersionPolicy VERSIONED_UPDATE = ResourceVersionPolicy.builder().value(Value.VERSIONED_UPDATE).build();
    private volatile int hashCode;

    private ResourceVersionPolicy(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static ResourceVersionPolicy of(Value value) {
        switch (value) {
            case NO_VERSION: {
                return NO_VERSION;
            }
            case VERSIONED: {
                return VERSIONED;
            }
            case VERSIONED_UPDATE: {
                return VERSIONED_UPDATE;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static ResourceVersionPolicy of(java.lang.String value) {
        return ResourceVersionPolicy.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return ResourceVersionPolicy.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return ResourceVersionPolicy.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceVersionPolicy other = (ResourceVersionPolicy)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        NO_VERSION("no-version"),
        VERSIONED("versioned"),
        VERSIONED_UPDATE("versioned-update");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "no-version": {
                    return NO_VERSION;
                }
                case "versioned": {
                    return VERSIONED;
                }
                case "versioned-update": {
                    return VERSIONED_UPDATE;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public ResourceVersionPolicy build() {
            ResourceVersionPolicy resourceVersionPolicy = new ResourceVersionPolicy(this);
            if (this.validating) {
                this.validate(resourceVersionPolicy);
            }
            return resourceVersionPolicy;
        }

        protected void validate(ResourceVersionPolicy resourceVersionPolicy) {
            super.validate(resourceVersionPolicy);
        }

        protected Builder from(ResourceVersionPolicy resourceVersionPolicy) {
            super.from(resourceVersionPolicy);
            return this;
        }
    }
}

