/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type.code;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.System;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.String;

@System(value="http://hl7.org/fhir/search-modifier-code")
public class SearchModifierCode
extends Code {
    public static final SearchModifierCode MISSING = SearchModifierCode.builder().value(Value.MISSING).build();
    public static final SearchModifierCode EXACT = SearchModifierCode.builder().value(Value.EXACT).build();
    public static final SearchModifierCode CONTAINS = SearchModifierCode.builder().value(Value.CONTAINS).build();
    public static final SearchModifierCode NOT = SearchModifierCode.builder().value(Value.NOT).build();
    public static final SearchModifierCode TEXT = SearchModifierCode.builder().value(Value.TEXT).build();
    public static final SearchModifierCode IN = SearchModifierCode.builder().value(Value.IN).build();
    public static final SearchModifierCode NOT_IN = SearchModifierCode.builder().value(Value.NOT_IN).build();
    public static final SearchModifierCode BELOW = SearchModifierCode.builder().value(Value.BELOW).build();
    public static final SearchModifierCode ABOVE = SearchModifierCode.builder().value(Value.ABOVE).build();
    public static final SearchModifierCode TYPE = SearchModifierCode.builder().value(Value.TYPE).build();
    public static final SearchModifierCode IDENTIFIER = SearchModifierCode.builder().value(Value.IDENTIFIER).build();
    public static final SearchModifierCode OF_TYPE = SearchModifierCode.builder().value(Value.OF_TYPE).build();
    private volatile int hashCode;

    private SearchModifierCode(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static SearchModifierCode of(Value value) {
        switch (value) {
            case MISSING: {
                return MISSING;
            }
            case EXACT: {
                return EXACT;
            }
            case CONTAINS: {
                return CONTAINS;
            }
            case NOT: {
                return NOT;
            }
            case TEXT: {
                return TEXT;
            }
            case IN: {
                return IN;
            }
            case NOT_IN: {
                return NOT_IN;
            }
            case BELOW: {
                return BELOW;
            }
            case ABOVE: {
                return ABOVE;
            }
            case TYPE: {
                return TYPE;
            }
            case IDENTIFIER: {
                return IDENTIFIER;
            }
            case OF_TYPE: {
                return OF_TYPE;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static SearchModifierCode of(java.lang.String value) {
        return SearchModifierCode.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return SearchModifierCode.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return SearchModifierCode.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SearchModifierCode other = (SearchModifierCode)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        MISSING("missing"),
        EXACT("exact"),
        CONTAINS("contains"),
        NOT("not"),
        TEXT("text"),
        IN("in"),
        NOT_IN("not-in"),
        BELOW("below"),
        ABOVE("above"),
        TYPE("type"),
        IDENTIFIER("identifier"),
        OF_TYPE("ofType");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "missing": {
                    return MISSING;
                }
                case "exact": {
                    return EXACT;
                }
                case "contains": {
                    return CONTAINS;
                }
                case "not": {
                    return NOT;
                }
                case "text": {
                    return TEXT;
                }
                case "in": {
                    return IN;
                }
                case "not-in": {
                    return NOT_IN;
                }
                case "below": {
                    return BELOW;
                }
                case "above": {
                    return ABOVE;
                }
                case "type": {
                    return TYPE;
                }
                case "identifier": {
                    return IDENTIFIER;
                }
                case "ofType": {
                    return OF_TYPE;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public SearchModifierCode build() {
            SearchModifierCode searchModifierCode = new SearchModifierCode(this);
            if (this.validating) {
                this.validate(searchModifierCode);
            }
            return searchModifierCode;
        }

        protected void validate(SearchModifierCode searchModifierCode) {
            super.validate(searchModifierCode);
        }

        protected Builder from(SearchModifierCode searchModifierCode) {
            super.from(searchModifierCode);
            return this;
        }
    }
}

