/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type.code;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.System;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.String;

@System(value="http://hl7.org/fhir/slotstatus")
public class SlotStatus
extends Code {
    public static final SlotStatus BUSY = SlotStatus.builder().value(Value.BUSY).build();
    public static final SlotStatus FREE = SlotStatus.builder().value(Value.FREE).build();
    public static final SlotStatus BUSY_UNAVAILABLE = SlotStatus.builder().value(Value.BUSY_UNAVAILABLE).build();
    public static final SlotStatus BUSY_TENTATIVE = SlotStatus.builder().value(Value.BUSY_TENTATIVE).build();
    public static final SlotStatus ENTERED_IN_ERROR = SlotStatus.builder().value(Value.ENTERED_IN_ERROR).build();
    private volatile int hashCode;

    private SlotStatus(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static SlotStatus of(Value value) {
        switch (value) {
            case BUSY: {
                return BUSY;
            }
            case FREE: {
                return FREE;
            }
            case BUSY_UNAVAILABLE: {
                return BUSY_UNAVAILABLE;
            }
            case BUSY_TENTATIVE: {
                return BUSY_TENTATIVE;
            }
            case ENTERED_IN_ERROR: {
                return ENTERED_IN_ERROR;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static SlotStatus of(java.lang.String value) {
        return SlotStatus.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return SlotStatus.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return SlotStatus.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SlotStatus other = (SlotStatus)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        BUSY("busy"),
        FREE("free"),
        BUSY_UNAVAILABLE("busy-unavailable"),
        BUSY_TENTATIVE("busy-tentative"),
        ENTERED_IN_ERROR("entered-in-error");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "busy": {
                    return BUSY;
                }
                case "free": {
                    return FREE;
                }
                case "busy-unavailable": {
                    return BUSY_UNAVAILABLE;
                }
                case "busy-tentative": {
                    return BUSY_TENTATIVE;
                }
                case "entered-in-error": {
                    return ENTERED_IN_ERROR;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public SlotStatus build() {
            SlotStatus slotStatus = new SlotStatus(this);
            if (this.validating) {
                this.validate(slotStatus);
            }
            return slotStatus;
        }

        protected void validate(SlotStatus slotStatus) {
            super.validate(slotStatus);
        }

        protected Builder from(SlotStatus slotStatus) {
            super.from(slotStatus);
            return this;
        }
    }
}

