/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type.code;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.System;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.String;

@System(value="http://hl7.org/fhir/map-context-type")
public class StructureMapContextType
extends Code {
    public static final StructureMapContextType TYPE = StructureMapContextType.builder().value(Value.TYPE).build();
    public static final StructureMapContextType VARIABLE = StructureMapContextType.builder().value(Value.VARIABLE).build();
    private volatile int hashCode;

    private StructureMapContextType(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static StructureMapContextType of(Value value) {
        switch (value) {
            case TYPE: {
                return TYPE;
            }
            case VARIABLE: {
                return VARIABLE;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static StructureMapContextType of(java.lang.String value) {
        return StructureMapContextType.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return StructureMapContextType.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return StructureMapContextType.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StructureMapContextType other = (StructureMapContextType)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        TYPE("type"),
        VARIABLE("variable");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "type": {
                    return TYPE;
                }
                case "variable": {
                    return VARIABLE;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public StructureMapContextType build() {
            StructureMapContextType structureMapContextType = new StructureMapContextType(this);
            if (this.validating) {
                this.validate(structureMapContextType);
            }
            return structureMapContextType;
        }

        protected void validate(StructureMapContextType structureMapContextType) {
            super.validate(structureMapContextType);
        }

        protected Builder from(StructureMapContextType structureMapContextType) {
            super.from(structureMapContextType);
            return this;
        }
    }
}

