/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type.code;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.System;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.String;

@System(value="http://hl7.org/fhir/map-group-type-mode")
public class StructureMapGroupTypeMode
extends Code {
    public static final StructureMapGroupTypeMode NONE = StructureMapGroupTypeMode.builder().value(Value.NONE).build();
    public static final StructureMapGroupTypeMode TYPES = StructureMapGroupTypeMode.builder().value(Value.TYPES).build();
    public static final StructureMapGroupTypeMode TYPE_AND_TYPES = StructureMapGroupTypeMode.builder().value(Value.TYPE_AND_TYPES).build();
    private volatile int hashCode;

    private StructureMapGroupTypeMode(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static StructureMapGroupTypeMode of(Value value) {
        switch (value) {
            case NONE: {
                return NONE;
            }
            case TYPES: {
                return TYPES;
            }
            case TYPE_AND_TYPES: {
                return TYPE_AND_TYPES;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static StructureMapGroupTypeMode of(java.lang.String value) {
        return StructureMapGroupTypeMode.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return StructureMapGroupTypeMode.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return StructureMapGroupTypeMode.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StructureMapGroupTypeMode other = (StructureMapGroupTypeMode)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        NONE("none"),
        TYPES("types"),
        TYPE_AND_TYPES("type-and-types");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "none": {
                    return NONE;
                }
                case "types": {
                    return TYPES;
                }
                case "type-and-types": {
                    return TYPE_AND_TYPES;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public StructureMapGroupTypeMode build() {
            StructureMapGroupTypeMode structureMapGroupTypeMode = new StructureMapGroupTypeMode(this);
            if (this.validating) {
                this.validate(structureMapGroupTypeMode);
            }
            return structureMapGroupTypeMode;
        }

        protected void validate(StructureMapGroupTypeMode structureMapGroupTypeMode) {
            super.validate(structureMapGroupTypeMode);
        }

        protected Builder from(StructureMapGroupTypeMode structureMapGroupTypeMode) {
            super.from(structureMapGroupTypeMode);
            return this;
        }
    }
}

