/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type.code;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.System;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.String;

@System(value="http://hl7.org/fhir/subscription-notification-type")
public class SubscriptionNotificationType
extends Code {
    public static final SubscriptionNotificationType HANDSHAKE = SubscriptionNotificationType.builder().value(Value.HANDSHAKE).build();
    public static final SubscriptionNotificationType HEARTBEAT = SubscriptionNotificationType.builder().value(Value.HEARTBEAT).build();
    public static final SubscriptionNotificationType EVENT_NOTIFICATION = SubscriptionNotificationType.builder().value(Value.EVENT_NOTIFICATION).build();
    public static final SubscriptionNotificationType QUERY_STATUS = SubscriptionNotificationType.builder().value(Value.QUERY_STATUS).build();
    public static final SubscriptionNotificationType QUERY_EVENT = SubscriptionNotificationType.builder().value(Value.QUERY_EVENT).build();
    private volatile int hashCode;

    private SubscriptionNotificationType(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static SubscriptionNotificationType of(Value value) {
        switch (value) {
            case HANDSHAKE: {
                return HANDSHAKE;
            }
            case HEARTBEAT: {
                return HEARTBEAT;
            }
            case EVENT_NOTIFICATION: {
                return EVENT_NOTIFICATION;
            }
            case QUERY_STATUS: {
                return QUERY_STATUS;
            }
            case QUERY_EVENT: {
                return QUERY_EVENT;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static SubscriptionNotificationType of(java.lang.String value) {
        return SubscriptionNotificationType.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return SubscriptionNotificationType.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return SubscriptionNotificationType.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubscriptionNotificationType other = (SubscriptionNotificationType)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        HANDSHAKE("handshake"),
        HEARTBEAT("heartbeat"),
        EVENT_NOTIFICATION("event-notification"),
        QUERY_STATUS("query-status"),
        QUERY_EVENT("query-event");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "handshake": {
                    return HANDSHAKE;
                }
                case "heartbeat": {
                    return HEARTBEAT;
                }
                case "event-notification": {
                    return EVENT_NOTIFICATION;
                }
                case "query-status": {
                    return QUERY_STATUS;
                }
                case "query-event": {
                    return QUERY_EVENT;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public SubscriptionNotificationType build() {
            SubscriptionNotificationType subscriptionNotificationType = new SubscriptionNotificationType(this);
            if (this.validating) {
                this.validate(subscriptionNotificationType);
            }
            return subscriptionNotificationType;
        }

        protected void validate(SubscriptionNotificationType subscriptionNotificationType) {
            super.validate(subscriptionNotificationType);
        }

        protected Builder from(SubscriptionNotificationType subscriptionNotificationType) {
            super.from(subscriptionNotificationType);
            return this;
        }
    }
}

