/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type.code;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.System;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.String;

@System(value="http://hl7.org/fhir/supplyrequest-status")
public class SupplyRequestStatus
extends Code {
    public static final SupplyRequestStatus DRAFT = SupplyRequestStatus.builder().value(Value.DRAFT).build();
    public static final SupplyRequestStatus ACTIVE = SupplyRequestStatus.builder().value(Value.ACTIVE).build();
    public static final SupplyRequestStatus SUSPENDED = SupplyRequestStatus.builder().value(Value.SUSPENDED).build();
    public static final SupplyRequestStatus CANCELLED = SupplyRequestStatus.builder().value(Value.CANCELLED).build();
    public static final SupplyRequestStatus COMPLETED = SupplyRequestStatus.builder().value(Value.COMPLETED).build();
    public static final SupplyRequestStatus ENTERED_IN_ERROR = SupplyRequestStatus.builder().value(Value.ENTERED_IN_ERROR).build();
    public static final SupplyRequestStatus UNKNOWN = SupplyRequestStatus.builder().value(Value.UNKNOWN).build();
    private volatile int hashCode;

    private SupplyRequestStatus(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static SupplyRequestStatus of(Value value) {
        switch (value) {
            case DRAFT: {
                return DRAFT;
            }
            case ACTIVE: {
                return ACTIVE;
            }
            case SUSPENDED: {
                return SUSPENDED;
            }
            case CANCELLED: {
                return CANCELLED;
            }
            case COMPLETED: {
                return COMPLETED;
            }
            case ENTERED_IN_ERROR: {
                return ENTERED_IN_ERROR;
            }
            case UNKNOWN: {
                return UNKNOWN;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static SupplyRequestStatus of(java.lang.String value) {
        return SupplyRequestStatus.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return SupplyRequestStatus.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return SupplyRequestStatus.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SupplyRequestStatus other = (SupplyRequestStatus)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        DRAFT("draft"),
        ACTIVE("active"),
        SUSPENDED("suspended"),
        CANCELLED("cancelled"),
        COMPLETED("completed"),
        ENTERED_IN_ERROR("entered-in-error"),
        UNKNOWN("unknown");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "draft": {
                    return DRAFT;
                }
                case "active": {
                    return ACTIVE;
                }
                case "suspended": {
                    return SUSPENDED;
                }
                case "cancelled": {
                    return CANCELLED;
                }
                case "completed": {
                    return COMPLETED;
                }
                case "entered-in-error": {
                    return ENTERED_IN_ERROR;
                }
                case "unknown": {
                    return UNKNOWN;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public SupplyRequestStatus build() {
            SupplyRequestStatus supplyRequestStatus = new SupplyRequestStatus(this);
            if (this.validating) {
                this.validate(supplyRequestStatus);
            }
            return supplyRequestStatus;
        }

        protected void validate(SupplyRequestStatus supplyRequestStatus) {
            super.validate(supplyRequestStatus);
        }

        protected Builder from(SupplyRequestStatus supplyRequestStatus) {
            super.from(supplyRequestStatus);
            return this;
        }
    }
}

