/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.type.code;

import java.util.Collection;
import java.util.Objects;
import org.linuxforhealth.fhir.model.annotation.System;
import org.linuxforhealth.fhir.model.type.Code;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.String;

@System(value="http://hl7.org/fhir/task-status")
public class TaskStatus
extends Code {
    public static final TaskStatus DRAFT = TaskStatus.builder().value(Value.DRAFT).build();
    public static final TaskStatus REQUESTED = TaskStatus.builder().value(Value.REQUESTED).build();
    public static final TaskStatus RECEIVED = TaskStatus.builder().value(Value.RECEIVED).build();
    public static final TaskStatus ACCEPTED = TaskStatus.builder().value(Value.ACCEPTED).build();
    public static final TaskStatus REJECTED = TaskStatus.builder().value(Value.REJECTED).build();
    public static final TaskStatus READY = TaskStatus.builder().value(Value.READY).build();
    public static final TaskStatus CANCELLED = TaskStatus.builder().value(Value.CANCELLED).build();
    public static final TaskStatus IN_PROGRESS = TaskStatus.builder().value(Value.IN_PROGRESS).build();
    public static final TaskStatus ON_HOLD = TaskStatus.builder().value(Value.ON_HOLD).build();
    public static final TaskStatus FAILED = TaskStatus.builder().value(Value.FAILED).build();
    public static final TaskStatus COMPLETED = TaskStatus.builder().value(Value.COMPLETED).build();
    public static final TaskStatus ENTERED_IN_ERROR = TaskStatus.builder().value(Value.ENTERED_IN_ERROR).build();
    private volatile int hashCode;

    private TaskStatus(Builder builder) {
        super(builder);
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    public static TaskStatus of(Value value) {
        switch (value) {
            case DRAFT: {
                return DRAFT;
            }
            case REQUESTED: {
                return REQUESTED;
            }
            case RECEIVED: {
                return RECEIVED;
            }
            case ACCEPTED: {
                return ACCEPTED;
            }
            case REJECTED: {
                return REJECTED;
            }
            case READY: {
                return READY;
            }
            case CANCELLED: {
                return CANCELLED;
            }
            case IN_PROGRESS: {
                return IN_PROGRESS;
            }
            case ON_HOLD: {
                return ON_HOLD;
            }
            case FAILED: {
                return FAILED;
            }
            case COMPLETED: {
                return COMPLETED;
            }
            case ENTERED_IN_ERROR: {
                return ENTERED_IN_ERROR;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static TaskStatus of(java.lang.String value) {
        return TaskStatus.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return TaskStatus.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return TaskStatus.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskStatus other = (TaskStatus)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        DRAFT("draft"),
        REQUESTED("requested"),
        RECEIVED("received"),
        ACCEPTED("accepted"),
        REJECTED("rejected"),
        READY("ready"),
        CANCELLED("cancelled"),
        IN_PROGRESS("in-progress"),
        ON_HOLD("on-hold"),
        FAILED("failed"),
        COMPLETED("completed"),
        ENTERED_IN_ERROR("entered-in-error");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "draft": {
                    return DRAFT;
                }
                case "requested": {
                    return REQUESTED;
                }
                case "received": {
                    return RECEIVED;
                }
                case "accepted": {
                    return ACCEPTED;
                }
                case "rejected": {
                    return REJECTED;
                }
                case "ready": {
                    return READY;
                }
                case "cancelled": {
                    return CANCELLED;
                }
                case "in-progress": {
                    return IN_PROGRESS;
                }
                case "on-hold": {
                    return ON_HOLD;
                }
                case "failed": {
                    return FAILED;
                }
                case "completed": {
                    return COMPLETED;
                }
                case "entered-in-error": {
                    return ENTERED_IN_ERROR;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public TaskStatus build() {
            TaskStatus taskStatus = new TaskStatus(this);
            if (this.validating) {
                this.validate(taskStatus);
            }
            return taskStatus;
        }

        protected void validate(TaskStatus taskStatus) {
            super.validate(taskStatus);
        }

        protected Builder from(TaskStatus taskStatus) {
            super.from(taskStatus);
            return this;
        }
    }
}

