/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.ucum.util;

import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.linuxforhealth.fhir.model.ucum.UCUMLexer;
import org.linuxforhealth.fhir.model.ucum.UCUMParser;

public class UCUMUtil {
    private static final ANTLRErrorListener SYNTAX_ERROR_LISTENER = new BaseErrorListener(){

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            throw new ParseCancellationException(String.format("line %d:%d %s", line, charPositionInLine, msg), (Throwable)e);
        }
    };

    private UCUMUtil() {
    }

    public static boolean isValidUcum(String ucumString) {
        try {
            UCUMLexer lexer = new UCUMLexer((CharStream)CharStreams.fromString((String)ucumString));
            lexer.removeErrorListeners();
            lexer.addErrorListener(SYNTAX_ERROR_LISTENER);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            UCUMParser parser = new UCUMParser((TokenStream)tokens);
            parser.removeErrorListeners();
            parser.addErrorListener(SYNTAX_ERROR_LISTENER);
            UCUMParser.MainTermContext expression = parser.mainTerm();
            return expression != null;
        }
        catch (ParseCancellationException e) {
            return false;
        }
    }
}

