/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.util;

import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.linuxforhealth.fhir.exception.FHIRException;
import org.linuxforhealth.fhir.exception.FHIROperationException;
import org.linuxforhealth.fhir.model.config.FHIRModelConfig;
import org.linuxforhealth.fhir.model.generator.FHIRGenerator;
import org.linuxforhealth.fhir.model.resource.Bundle;
import org.linuxforhealth.fhir.model.resource.DomainResource;
import org.linuxforhealth.fhir.model.resource.OperationOutcome;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.CodeableConcept;
import org.linuxforhealth.fhir.model.type.Coding;
import org.linuxforhealth.fhir.model.type.Element;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.Id;
import org.linuxforhealth.fhir.model.type.Meta;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.Uri;
import org.linuxforhealth.fhir.model.type.Uuid;
import org.linuxforhealth.fhir.model.type.code.BundleType;
import org.linuxforhealth.fhir.model.type.code.DataAbsentReason;
import org.linuxforhealth.fhir.model.type.code.IssueSeverity;
import org.linuxforhealth.fhir.model.type.code.IssueType;
import org.linuxforhealth.fhir.model.util.ModelSupport;
import org.linuxforhealth.fhir.model.util.ReferenceMappingVisitor;
import org.linuxforhealth.fhir.model.util.ReferenceType;
import org.linuxforhealth.fhir.model.visitor.Visitable;

public class FHIRUtil {
    private static final Logger log = Logger.getLogger(FHIRUtil.class.getName());
    public static final Pattern REFERENCE_PATTERN = FHIRUtil.buildReferencePattern();
    public static final Extension DATA_ABSENT_REASON_UNKNOWN = Extension.builder().url("http://hl7.org/fhir/StructureDefinition/data-absent-reason").value(DataAbsentReason.UNKNOWN).build();
    public static final org.linuxforhealth.fhir.model.type.String STRING_DATA_ABSENT_REASON_UNKNOWN = org.linuxforhealth.fhir.model.type.String.builder().extension(DATA_ABSENT_REASON_UNKNOWN).build();
    private static final JsonBuilderFactory BUILDER_FACTORY = Json.createBuilderFactory(null);
    public static final OperationOutcome ALL_OK = OperationOutcome.builder().issue(OperationOutcome.Issue.builder().severity(IssueSeverity.INFORMATION).code(IssueType.INFORMATIONAL).details(CodeableConcept.builder().text(org.linuxforhealth.fhir.model.type.String.string("All OK")).build()).build()).build();

    private FHIRUtil() {
    }

    public static void init() {
    }

    public static String toString(Visitable visitable) {
        try {
            FHIRGenerator generator = FHIRGenerator.generator(FHIRModelConfig.getToStringFormat(), FHIRModelConfig.getToStringPrettyPrinting());
            if (generator.isPropertySupported("org.linuxforhealth.fhir.model.generator.indentAmount")) {
                generator.setProperty("org.linuxforhealth.fhir.model.generator.indentAmount", FHIRModelConfig.getToStringIndentAmount());
            }
            StringWriter writer = new StringWriter();
            generator.generate(visitable, writer);
            return writer.toString();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private static Pattern buildReferencePattern() {
        StringBuilder sb = new StringBuilder();
        sb.append("((http|https)://([A-Za-z0-9\\\\\\/\\.\\:\\%\\$\\-])*)?(");
        sb.append(ModelSupport.getResourceTypes(false).stream().map(Class::getSimpleName).collect(Collectors.joining("|")));
        sb.append(")\\/([A-Za-z0-9\\-\\.]{1,64})(\\/_history\\/([A-Za-z0-9\\-\\.]{1,64}))?");
        return Pattern.compile(sb.toString());
    }

    public static JsonObjectBuilder toJsonObjectBuilder(JsonObject jsonObject) {
        JsonObjectBuilder builder = BUILDER_FACTORY.createObjectBuilder();
        for (String key : jsonObject.keySet()) {
            JsonValue value = (JsonValue)jsonObject.get((Object)key);
            builder.add(key, value);
        }
        return builder;
    }

    public static OperationOutcome.Issue buildOperationOutcomeIssue(String msg, IssueType code) {
        return FHIRUtil.buildOperationOutcomeIssue(IssueSeverity.FATAL, code, msg, null);
    }

    public static OperationOutcome.Issue buildOperationOutcomeIssue(IssueSeverity severity, IssueType code, String details) {
        return FHIRUtil.buildOperationOutcomeIssue(severity, code, details, null);
    }

    public static OperationOutcome.Issue buildOperationOutcomeIssue(IssueSeverity severity, IssueType code, String details, String expression) {
        OperationOutcome.Issue.Builder builder = OperationOutcome.Issue.builder().severity(severity).code(code);
        if (details != null && !details.isEmpty()) {
            builder.details(CodeableConcept.builder().text(org.linuxforhealth.fhir.model.type.String.string(details)).build());
        }
        if (expression != null && !expression.isEmpty()) {
            builder.expression(Collections.singletonList(org.linuxforhealth.fhir.model.type.String.string(expression)));
        }
        return builder.build();
    }

    public static OperationOutcome buildOperationOutcome(Collection<OperationOutcome.Issue> issues) {
        if (issues == null || issues.isEmpty()) {
            return ALL_OK;
        }
        return OperationOutcome.builder().issue(issues).build();
    }

    public static OperationOutcome buildOperationOutcome(FHIROperationException e, boolean includeCausedByClauses) {
        if (e.getIssues() != null && e.getIssues().size() > 0) {
            String id = e.getUniqueId();
            return FHIRUtil.buildOperationOutcome(e.getIssues()).toBuilder().id(id).build();
        }
        return FHIRUtil.buildOperationOutcome((FHIRException)e, includeCausedByClauses);
    }

    public static OperationOutcome buildOperationOutcome(FHIRException e, boolean includeCausedByClauses) {
        String id = e.getUniqueId();
        return FHIRUtil.buildOperationOutcome((Exception)e, includeCausedByClauses).toBuilder().id(id).build();
    }

    public static OperationOutcome buildOperationOutcome(Exception exception, boolean includeCausedByClauses) {
        return FHIRUtil.buildOperationOutcome(exception, null, null, includeCausedByClauses);
    }

    public static OperationOutcome buildOperationOutcome(Exception exception, IssueType issueType, IssueSeverity severity, boolean includeCausedByClauses) {
        StringBuilder msgs = new StringBuilder();
        Throwable e = exception;
        Object causedBy = "";
        while (e != null) {
            msgs.append((String)causedBy + e.getClass().getSimpleName() + ": " + (e.getMessage() != null ? e.getMessage().replaceAll("<", "&lt;").replaceAll(">", "&gt;") : "&lt;null message&gt;"));
            e = e.getCause();
            causedBy = System.lineSeparator() + "Caused by: ";
            if (includeCausedByClauses) continue;
            e = null;
        }
        return FHIRUtil.buildOperationOutcome(msgs.toString(), issueType, severity);
    }

    public static OperationOutcome buildOperationOutcome(String message, IssueType issueType, IssueSeverity severity) {
        if (issueType == null) {
            issueType = IssueType.EXCEPTION;
        }
        if (severity == null) {
            severity = IssueSeverity.FATAL;
        }
        OperationOutcome.Issue ooi = OperationOutcome.Issue.builder().severity(severity).code(issueType).details(CodeableConcept.builder().text(org.linuxforhealth.fhir.model.type.String.string(message)).build()).build();
        OperationOutcome oo = OperationOutcome.builder().issue(Collections.singletonList(ooi)).build();
        return oo;
    }

    public static URI buildLocationURI(String type, Resource resource) {
        StringBuilder sb = new StringBuilder();
        sb.append(type);
        sb.append("/");
        sb.append(resource.getId());
        sb.append("/_history/");
        sb.append(resource.getMeta().getVersionId().getValue());
        return URI.create(sb.toString());
    }

    public static URI buildLocationURI(String type, String id, int version) {
        StringBuilder sb = new StringBuilder();
        sb.append(type);
        sb.append("/");
        sb.append(id);
        sb.append("/_history/");
        sb.append(version);
        return URI.create(sb.toString());
    }

    public static Resource resolveReference(Reference ref, DomainResource resource, Bundle bundle, Bundle.Entry entry) throws Exception {
        switch (ReferenceType.of(ref)) {
            case CONTAINED: {
                return FHIRUtil.resolveContainedReference(resource, ref);
            }
            case ABSOLUTE_FHIR_URL: 
            case RELATIVE_FHIR_URL: 
            case ABSOLUTE_UUID: 
            case ABSOLUTE_OID: 
            case ABSOLUTE_OTHER_URL: 
            case OTHER: {
                Bundle.Entry targetEntry = FHIRUtil.resolveBundleReference(bundle, entry, ref);
                return targetEntry.getResource();
            }
            case NO_REFERENCE_VALUE: {
                throw new FHIRException("Reference must have a nonempty value to be resolved");
            }
        }
        throw new FHIRException("Cannot resolve invalid reference value " + ref.getReference().getValue());
    }

    public static Resource resolveContainedReference(DomainResource resource, Reference ref) throws Exception {
        if (ref == null || ref.getReference() == null || ref.getReference().getValue() == null) {
            throw new FHIRException("Reference must have a nonempty value to be resolved");
        }
        String referenceUriString = ref.getReference().getValue();
        if (referenceUriString.startsWith("#")) {
            referenceUriString = referenceUriString.substring(1);
            List<Resource> containedResources = resource.getContained();
            for (Resource containedResource : containedResources) {
                String id = containedResource.getId();
                if (id == null || !referenceUriString.equals(id)) continue;
                return containedResource;
            }
        }
        throw new FHIRException("Resource does not contain the referenced resource");
    }

    public static <T extends Resource> T resolveBundleReference(Class<T> resourceType, Bundle bundle, Bundle.Entry sourceEntry, Reference ref) throws Exception {
        Bundle.Entry targetEntry = FHIRUtil.resolveBundleReference(bundle, sourceEntry, ref);
        return (T)targetEntry.getResource();
    }

    public static Bundle.Entry resolveBundleReference(Bundle bundle, Bundle.Entry sourceEntry, Reference ref) throws FHIRException, URISyntaxException {
        String version;
        if (ref == null || ref.getReference() == null || ref.getReference().getValue() == null) {
            throw new FHIRException("Reference must have a nonempty value to be resolved");
        }
        Object referenceUriString = ref.getReference().getValue();
        URI referenceUri = new URI((String)referenceUriString);
        if (!referenceUri.isAbsolute()) {
            if (((String)referenceUriString).startsWith("#")) {
                throw new IllegalArgumentException("Cannot resolve fragment reference " + (String)referenceUriString + " to a BundleEntry. See resolveReference instead.");
            }
            Uri sourceEntryFullUrl = sourceEntry.getFullUrl();
            if (sourceEntryFullUrl != null) {
                String sourceEntryUriString = sourceEntryFullUrl.getValue();
                URI sourceEntryUri = new URI(sourceEntryUriString);
                if (!sourceEntryUri.isAbsolute()) {
                    throw new FHIRException("The Bundle entry that contains the reference must have an absolute fullUrl to resolve relative references");
                }
                Matcher restUrlMatcher = REFERENCE_PATTERN.matcher(sourceEntryUriString);
                if (restUrlMatcher.matches() && restUrlMatcher.groupCount() > 0) {
                    String urlBase = restUrlMatcher.group(1);
                    referenceUriString = urlBase + (String)referenceUriString;
                }
            }
        }
        if ((version = referenceUri.getFragment()) != null) {
            referenceUriString = ((String)referenceUriString).substring(0, ((String)referenceUriString).length() - version.length());
        }
        for (Bundle.Entry entry : bundle.getEntry()) {
            String fullUrlValue;
            Uri fullUrl = entry.getFullUrl();
            if (fullUrl == null || (fullUrlValue = entry.getFullUrl().getValue()) == null || !fullUrlValue.equals(referenceUriString)) continue;
            try {
                Resource resource = entry.getResource();
                if (version != null && resource.getMeta() != null && resource.getMeta().getVersionId() != null) {
                    Id versionId = resource.getMeta().getVersionId();
                    if (!version.equals(versionId.getValue())) continue;
                    return entry;
                }
                return entry;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Unable to retrieve resource " + (String)referenceUriString + " from the bundle", e);
            }
        }
        throw new FHIRException("Bundle does not contain the referenced resource and retrieval of resources outside the bundle is not supported.");
    }

    public static String getExtensionStringValue(Resource resource, String extensionUrl) {
        String value = null;
        if (Objects.nonNull(resource) && Objects.nonNull(extensionUrl) && resource instanceof DomainResource) {
            DomainResource dr = (DomainResource)resource;
            value = FHIRUtil.getExtensionStringValue(extensionUrl, dr.getExtension());
        }
        return value;
    }

    public static String getExtensionStringValue(Element element, String extensionUrl) {
        String value = null;
        if (Objects.nonNull(element) && Objects.nonNull(extensionUrl)) {
            value = FHIRUtil.getExtensionStringValue(extensionUrl, element.getExtension());
        }
        return value;
    }

    private static String getExtensionStringValue(String extensionUrl, List<Extension> extensions) {
        String value = null;
        for (Extension ext : extensions) {
            if (ext.getValue() == null || !ext.getUrl().equals(extensionUrl) || !ext.getValue().is(org.linuxforhealth.fhir.model.type.String.class)) continue;
            value = ext.getValue().as(org.linuxforhealth.fhir.model.type.String.class).getValue();
            break;
        }
        return value;
    }

    public static boolean hasTag(Resource resource, Coding tag) {
        Objects.requireNonNull(resource);
        Objects.requireNonNull(tag);
        if (resource.getMeta() == null) {
            return false;
        }
        for (Coding t : resource.getMeta().getTag()) {
            if (tag.getSystem() == null || !tag.getSystem().equals(t.getSystem()) || tag.getCode() == null || !tag.getCode().equals(t.getCode())) continue;
            return true;
        }
        return false;
    }

    public static <T extends Resource> T addTag(T resource, Coding tag) {
        Objects.requireNonNull(resource);
        Objects.requireNonNull(tag);
        if (FHIRUtil.hasTag(resource, tag)) {
            return resource;
        }
        Meta meta = resource.getMeta();
        Meta.Builder metaBuilder = meta == null ? Meta.builder() : meta.toBuilder();
        Resource updatedResource = resource.toBuilder().meta(metaBuilder.tag(tag).build()).build();
        return (T)updatedResource;
    }

    public static boolean anyFailureInIssues(List<OperationOutcome.Issue> issues) {
        for (OperationOutcome.Issue issue : issues) {
            if (!FHIRUtil.isFailure(issue.getSeverity())) continue;
            return true;
        }
        return false;
    }

    public static boolean isFailure(IssueSeverity severity) {
        switch (severity.getValueAsEnum()) {
            case INFORMATION: 
            case WARNING: {
                return false;
            }
        }
        return true;
    }

    public static Bundle createStandaloneBundle(BundleType bundleType, Map<String, Resource> resources) {
        HashMap<String, String> localRefMap = new HashMap<String, String>();
        ArrayList<Bundle.Entry> entries = new ArrayList<Bundle.Entry>();
        for (String key : resources.keySet()) {
            Uuid uuid = Uuid.of("urn:uuid:" + UUID.randomUUID());
            localRefMap.put(key, uuid.getValue());
            entries.add(Bundle.Entry.builder().fullUrl(uuid).resource(resources.get(key)).build());
        }
        Bundle bundle = Bundle.builder().type(bundleType).entry(entries).build();
        ReferenceMappingVisitor referenceMappingVisitor = new ReferenceMappingVisitor(localRefMap, null);
        bundle.accept(referenceMappingVisitor);
        return (Bundle)referenceMappingVisitor.getResult();
    }

    public static String buildBundleReference(Reference ref, String fullUrlString) {
        Object referenceUriString;
        block5: {
            referenceUriString = null;
            if (ref.getReference() != null && ref.getReference().getValue() != null) {
                referenceUriString = ref.getReference().getValue();
                if (fullUrlString != null) {
                    try {
                        Matcher restUrlMatcher;
                        URI fullUrl;
                        URI referenceUri = new URI((String)referenceUriString);
                        if (!referenceUri.isAbsolute() && !((String)referenceUriString).startsWith("#") && (fullUrl = new URI(fullUrlString)).isAbsolute() && (restUrlMatcher = REFERENCE_PATTERN.matcher(fullUrlString)).matches() && restUrlMatcher.groupCount() > 0) {
                            String urlBase = restUrlMatcher.group(1);
                            referenceUriString = urlBase + (String)referenceUriString;
                        }
                    }
                    catch (URISyntaxException e) {
                        if (!log.isLoggable(Level.FINE)) break block5;
                        log.fine("Reference string or fullUrlString is not a valid URI; returning '" + (String)referenceUriString + "'");
                    }
                }
            }
        }
        return referenceUriString;
    }
}

