/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.util;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.type.String;
import org.linuxforhealth.fhir.model.util.FHIRUtil;
import org.linuxforhealth.fhir.model.visitor.CopyingVisitor;
import org.linuxforhealth.fhir.model.visitor.Visitable;

public class ReferenceMappingVisitor<T extends Visitable>
extends CopyingVisitor<T> {
    private static final Logger log = Logger.getLogger(ReferenceMappingVisitor.class.getName());
    private Map<java.lang.String, java.lang.String> localRefMap;
    private java.lang.String localIdentifier;

    public ReferenceMappingVisitor(Map<java.lang.String, java.lang.String> localRefMap, java.lang.String localIdentifier) {
        this.localRefMap = localRefMap;
        this.localIdentifier = localIdentifier;
    }

    @Override
    public boolean visit(java.lang.String elementName, int elementIndex, Reference reference) {
        if (reference != null && reference.getReference() != null && reference.getReference().hasValue()) {
            java.lang.String refValue = FHIRUtil.buildBundleReference(reference, this.localIdentifier);
            java.lang.String newRefValue = this.localRefMap.get(refValue);
            if (newRefValue != null) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Replacing '" + refValue + "' with new value '" + newRefValue + "'");
                }
                ((Reference.Builder)this.getBuilder()).reference(String.string(newRefValue));
                this.markDirty();
            } else if (log.isLoggable(Level.FINER)) {
                log.finer("Reference '" + reference.getReference().getValue() + "' is not replaced because it was not found in the local reference map");
            }
        }
        return false;
    }
}

