/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import org.linuxforhealth.fhir.model.type.Reference;
import org.linuxforhealth.fhir.model.util.FHIRUtil;

public enum ReferenceType {
    NO_REFERENCE_VALUE,
    CONTAINED,
    ABSOLUTE_FHIR_URL,
    RELATIVE_FHIR_URL,
    ABSOLUTE_OTHER_URL,
    ABSOLUTE_OID,
    ABSOLUTE_UUID,
    OTHER,
    INVALID;


    public static ReferenceType of(Reference ref) {
        URI referenceUri;
        if (ref == null || ref.getReference() == null || ref.getReference().getValue() == null) {
            return NO_REFERENCE_VALUE;
        }
        String referenceUriString = ref.getReference().getValue();
        if (referenceUriString.startsWith("#")) {
            return CONTAINED;
        }
        try {
            referenceUri = new URI(referenceUriString);
        }
        catch (URISyntaxException e) {
            return INVALID;
        }
        Matcher restUrlMatcher = FHIRUtil.REFERENCE_PATTERN.matcher(referenceUriString);
        boolean isFhirUrl = restUrlMatcher.matches();
        if (isFhirUrl) {
            if (referenceUri.isAbsolute()) {
                return ABSOLUTE_FHIR_URL;
            }
            return RELATIVE_FHIR_URL;
        }
        if (referenceUriString.startsWith("http://") || referenceUriString.startsWith("https://")) {
            return ABSOLUTE_OTHER_URL;
        }
        if (referenceUriString.startsWith("urn:oid:")) {
            return ABSOLUTE_OID;
        }
        if (referenceUriString.startsWith("urn:uuid:")) {
            return ABSOLUTE_UUID;
        }
        return OTHER;
    }
}

