/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.util;

import java.util.Arrays;
import java.util.Base64;

public class SaltHash {
    private final byte[] salt;
    private final byte[] hash;

    public SaltHash(byte[] salt, byte[] hash) {
        this.salt = salt;
        this.hash = hash;
    }

    public SaltHash(String tuple) {
        String[] values = tuple.split(":");
        if (values.length != 2) {
            throw new IllegalArgumentException("String must be salt:hash encoded as two Base64 encoded strings");
        }
        this.salt = Base64.getDecoder().decode(values[0]);
        this.hash = Base64.getDecoder().decode(values[1]);
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public byte[] getHash() {
        return this.hash;
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof SaltHash) {
            return Arrays.equals(this.salt, ((SaltHash)other).salt) && Arrays.equals(this.hash, ((SaltHash)other).hash);
        }
        return false;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(Base64.getEncoder().encodeToString(this.salt));
        result.append(":");
        result.append(Base64.getEncoder().encodeToString(this.hash));
        return result.toString();
    }
}

