/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.visitor;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import org.linuxforhealth.fhir.model.util.FHIRUtil;
import org.linuxforhealth.fhir.model.visitor.Visitable;
import org.linuxforhealth.fhir.model.visitor.Visitor;

public abstract class AbstractVisitable
implements Visitable {
    @Override
    public abstract void accept(String var1, int var2, Visitor var3);

    protected void accept(Visitable visitable, String elementName, Visitor visitor) {
        if (visitable != null) {
            visitable.accept(elementName, -1, visitor);
        }
    }

    protected void accept(List<? extends Visitable> visitables, String elementName, Visitor visitor, Class<?> type) {
        visitor.visitStart(elementName, visitables, type);
        if (!visitables.isEmpty()) {
            int elementIndex = 0;
            for (Visitable visitable : visitables) {
                visitable.accept(elementName, elementIndex, visitor);
                ++elementIndex;
            }
        }
        visitor.visitEnd(elementName, visitables, type);
    }

    protected void accept(BigDecimal value, String elementName, Visitor visitor) {
        if (value != null) {
            visitor.visit(elementName, value);
        }
    }

    protected void accept(byte[] value, String elementName, Visitor visitor) {
        if (value != null) {
            visitor.visit(elementName, value);
        }
    }

    protected void accept(Integer value, String elementName, Visitor visitor) {
        if (value != null) {
            visitor.visit(elementName, value);
        }
    }

    protected void accept(LocalDate value, String elementName, Visitor visitor) {
        if (value != null) {
            visitor.visit(elementName, value);
        }
    }

    protected void accept(LocalTime value, String elementName, Visitor visitor) {
        if (value != null) {
            visitor.visit(elementName, value);
        }
    }

    protected void accept(String value, String elementName, Visitor visitor) {
        if (value != null) {
            visitor.visit(elementName, value);
        }
    }

    protected void accept(Boolean value, String elementName, Visitor visitor) {
        if (value != null) {
            visitor.visit(elementName, value);
        }
    }

    protected void accept(Year value, String elementName, Visitor visitor) {
        if (value != null) {
            visitor.visit(elementName, value);
        }
    }

    protected void accept(YearMonth value, String elementName, Visitor visitor) {
        if (value != null) {
            visitor.visit(elementName, value);
        }
    }

    protected void accept(ZonedDateTime value, String elementName, Visitor visitor) {
        if (value != null) {
            visitor.visit(elementName, value);
        }
    }

    protected void accept(TemporalAccessor temporal, String elementName, Visitor visitor) {
        if (temporal instanceof ZonedDateTime) {
            visitor.visit(elementName, (ZonedDateTime)temporal);
        } else if (temporal instanceof LocalDate) {
            visitor.visit(elementName, (LocalDate)temporal);
        } else if (temporal instanceof YearMonth) {
            visitor.visit(elementName, (YearMonth)temporal);
        } else if (temporal instanceof Year) {
            visitor.visit(elementName, (Year)temporal);
        }
    }

    public String toString() {
        return FHIRUtil.toString(this);
    }
}

