/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.visitor;

import org.linuxforhealth.fhir.model.builder.Builder;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.Element;
import org.linuxforhealth.fhir.model.type.Extension;
import org.linuxforhealth.fhir.model.type.String;
import org.linuxforhealth.fhir.model.type.Xhtml;
import org.linuxforhealth.fhir.model.visitor.CopyingVisitor;
import org.owasp.encoder.Encode;

public class EncodingVisitor<T extends Resource>
extends CopyingVisitor<T> {
    private final EncodingContext context;

    public EncodingVisitor(EncodingContext context) {
        this.context = context;
    }

    @Override
    public boolean visit(String elementName, int elementIndex, Xhtml xhtml) {
        this.visit("id", xhtml.getId());
        for (Extension extension : xhtml.getExtension()) {
            extension.accept(this);
        }
        return false;
    }

    @Override
    public void visit(String elementName, String value) {
        if (value == null) {
            return;
        }
        String newValue = this.encode(value);
        if (newValue == value) {
            return;
        }
        Builder<?> builder = this.getBuilder();
        if (builder instanceof String.Builder) {
            ((String.Builder)builder).value(newValue);
            this.markDirty();
        } else if (builder instanceof Extension.Builder && "url".equals(elementName)) {
            ((Extension.Builder)this.getBuilder()).url(newValue);
            this.markDirty();
        } else if (builder instanceof Element.Builder && "id".equals(elementName)) {
            ((Element.Builder)this.getBuilder()).id(newValue);
            this.markDirty();
        } else {
            throw new UnsupportedOperationException("Encoding is not yet support for element '" + elementName + "' of builder " + builder.getClass().getName());
        }
    }

    private String encode(String string) {
        switch (this.context) {
            case JAVA: {
                return Encode.forJava((String)string);
            }
            case JAVASCRIPT: {
                return Encode.forJavaScript((String)string);
            }
            case HTML_CONTENT: {
                return Encode.forHtmlContent((String)string);
            }
            case HTML_ATTRIBUTE: {
                return Encode.forHtmlAttribute((String)string);
            }
        }
        return Encode.forHtml((String)string);
    }

    public static enum EncodingContext {
        HTML,
        HTML_CONTENT,
        HTML_ATTRIBUTE,
        JAVA,
        JAVASCRIPT;

    }
}

