/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.visitor;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.linuxforhealth.fhir.model.visitor.PathAwareVisitor;
import org.linuxforhealth.fhir.model.visitor.Visitable;

public class PathAwareCollectingVisitor<T>
extends PathAwareVisitor {
    protected final Map<String, T> result = new LinkedHashMap<String, T>();
    protected final Class<T> type;

    public PathAwareCollectingVisitor(Class<T> type) {
        this.type = type;
    }

    protected void collect(Object object) {
        if (this.type.isInstance(object)) {
            this.result.put(this.getPath(), this.type.cast(object));
        }
    }

    public Map<String, T> getResult() {
        return Collections.unmodifiableMap(this.result);
    }

    @Override
    public boolean visit(String elementName, int elementIndex, Visitable visitable) {
        this.collect(visitable);
        return true;
    }

    @Override
    public void doVisit(String elementName, byte[] value) {
        this.collect(value);
    }

    @Override
    public void doVisit(String elementName, BigDecimal value) {
        this.collect(value);
    }

    @Override
    public void doVisit(String elementName, Boolean value) {
        this.collect(value);
    }

    @Override
    public void doVisit(String elementName, Integer value) {
        this.collect(value);
    }

    @Override
    public void doVisit(String elementName, LocalDate value) {
        this.collect(value);
    }

    @Override
    public void doVisit(String elementName, LocalTime value) {
        this.collect(value);
    }

    @Override
    public void doVisit(String elementName, String value) {
        this.collect(value);
    }

    @Override
    public void doVisit(String elementName, Year value) {
        this.collect(value);
    }

    @Override
    public void doVisit(String elementName, YearMonth value) {
        this.collect(value);
    }

    @Override
    public void doVisit(String elementName, ZonedDateTime value) {
        this.collect(value);
    }
}

