/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.model.visitor;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.model.type.Instant;
import org.linuxforhealth.fhir.model.type.String;
import org.linuxforhealth.fhir.model.util.SaltHash;
import org.linuxforhealth.fhir.model.visitor.PathAwareVisitor;

public class ResourceFingerprintVisitor
extends PathAwareVisitor {
    private static final int BYTES_FOR_256_BITS = 32;
    private static final SecureRandom RANDOM = new SecureRandom();
    private final byte[] salt;
    private Set<java.lang.String> excludePaths;
    private final MessageDigest digest;

    public ResourceFingerprintVisitor(byte[] salt) {
        this.salt = salt;
        try {
            this.digest = MessageDigest.getInstance("SHA-256");
            this.digest.update(salt);
        }
        catch (NoSuchAlgorithmException x) {
            throw new IllegalStateException(x);
        }
    }

    public ResourceFingerprintVisitor(SaltHash baseline) {
        this(baseline.getSalt());
    }

    public ResourceFingerprintVisitor() {
        this.salt = new byte[32];
        RANDOM.nextBytes(this.salt);
        try {
            this.digest = MessageDigest.getInstance("SHA-256");
            this.digest.update(this.salt);
        }
        catch (NoSuchAlgorithmException x) {
            throw new IllegalStateException(x);
        }
    }

    public SaltHash getSaltAndHash() {
        return new SaltHash(this.salt, this.digest.digest());
    }

    @Override
    protected void doVisitStart(java.lang.String elementName, int elementIndex, Resource resource) {
        if (this.excludePaths == null) {
            java.lang.String currentResourceName = resource.getClass().getSimpleName();
            this.excludePaths = new HashSet<java.lang.String>(Arrays.asList(currentResourceName + ".id", currentResourceName + ".meta.versionId", currentResourceName + ".meta.lastUpdated"));
        }
    }

    @Override
    public boolean visit(java.lang.String elementName, int index, String value) {
        return this.includePath();
    }

    @Override
    public boolean visit(java.lang.String elementName, int index, Instant value) {
        return this.includePath();
    }

    @Override
    public void doVisit(java.lang.String elementName, byte[] value) {
        this.digest.update(this.getPath().getBytes(StandardCharsets.UTF_8));
        this.digest.update(value);
    }

    @Override
    public void doVisit(java.lang.String elementName, BigDecimal value) {
        this.updateDigest(this.getPath(), value.toString());
    }

    @Override
    public void doVisit(java.lang.String elementName, Boolean value) {
        this.updateDigest(this.getPath(), value.toString());
    }

    @Override
    public void doVisit(java.lang.String elementName, Integer value) {
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.putInt(value);
        bb.flip();
        this.digest.update(bb);
    }

    @Override
    public void doVisit(java.lang.String elementName, LocalDate value) {
        this.updateDigest(this.getPath(), value.toString());
    }

    @Override
    public void doVisit(java.lang.String elementName, LocalTime value) {
        this.updateDigest(this.getPath(), value.toString());
    }

    @Override
    public void doVisit(java.lang.String elementName, java.lang.String value) {
        if (this.includePath()) {
            this.updateDigest(this.getPath(), value);
        }
    }

    @Override
    public void doVisit(java.lang.String elementName, Year value) {
        this.updateDigest(this.getPath(), value.toString());
    }

    @Override
    public void doVisit(java.lang.String elementName, YearMonth value) {
        this.updateDigest(this.getPath(), value.toString());
    }

    @Override
    public void doVisit(java.lang.String elementName, ZonedDateTime value) {
        this.updateDigest(this.getPath(), value.toString());
    }

    protected void updateDigest(java.lang.String name, java.lang.String value) {
        this.digest.update(name.getBytes(StandardCharsets.UTF_8));
        this.digest.update(value.getBytes(StandardCharsets.UTF_8));
    }

    protected boolean includePath() {
        return this.excludePaths == null ? true : !this.excludePaths.contains(this.getPath());
    }
}

