/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.registry.spi;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.registry.FHIRRegistry;
import org.linuxforhealth.fhir.registry.resource.FHIRRegistryResource;
import org.linuxforhealth.fhir.registry.spi.FHIRRegistryResourceProvider;

public abstract class AbstractRegistryResourceProvider
implements FHIRRegistryResourceProvider {
    @Override
    public final FHIRRegistryResource getRegistryResource(Class<? extends Resource> resourceType, String url, String version) {
        Objects.requireNonNull(resourceType, "resourceType");
        Objects.requireNonNull(url, "url");
        List<FHIRRegistryResource> registryResources = this.getRegistryResources(resourceType, url);
        if (!registryResources.isEmpty()) {
            if (version != null) {
                FHIRRegistryResource.Version v = FHIRRegistryResource.Version.from(version);
                for (FHIRRegistryResource registryResource : registryResources) {
                    if (!registryResource.getVersion().equals(v)) continue;
                    return registryResource;
                }
            } else {
                for (FHIRRegistryResource registryResource : registryResources) {
                    if (!registryResource.isDefaultVersion()) continue;
                    return registryResource;
                }
                return registryResources.get(registryResources.size() - 1);
            }
        }
        return null;
    }

    protected <T extends Resource> T loadFromRegistry(String url, Class<T> resourceType) {
        return FHIRRegistry.getInstance().getResource(url, resourceType, this.getClass().getCanonicalName());
    }

    protected abstract List<FHIRRegistryResource> getRegistryResources(Class<? extends Resource> var1, String var2);

    @Override
    public abstract Collection<FHIRRegistryResource> getRegistryResources(Class<? extends Resource> var1);

    @Override
    public abstract Collection<FHIRRegistryResource> getRegistryResources();

    @Override
    public abstract Collection<FHIRRegistryResource> getProfileResources(String var1);

    @Override
    public abstract Collection<FHIRRegistryResource> getSearchParameterResources(String var1);
}

