/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.registry.util;

import java.util.Objects;
import org.linuxforhealth.fhir.model.resource.Resource;
import org.linuxforhealth.fhir.registry.resource.FHIRRegistryResource;
import org.linuxforhealth.fhir.registry.util.FHIRRegistryUtil;

public class PackageRegistryResource
extends FHIRRegistryResource {
    protected final String path;

    public PackageRegistryResource(Class<? extends Resource> resourceType, String id, String url, FHIRRegistryResource.Version version, String kind, String type, String path) {
        super(resourceType, id, url, version, kind, type);
        this.path = Objects.requireNonNull(path);
    }

    public String getPath() {
        return this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource getResource() {
        Resource resource = this.resource;
        if (resource == null) {
            PackageRegistryResource packageRegistryResource = this;
            synchronized (packageRegistryResource) {
                resource = this.resource;
                if (resource == null) {
                    this.resource = resource = FHIRRegistryUtil.loadResource(this.path);
                }
            }
        }
        return resource;
    }
}

