/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.hibernate.database;

import java.util.Map;
import liquibase.database.DatabaseConnection;
import liquibase.exception.DatabaseException;
import liquibase.ext.hibernate.customfactory.CustomEjb3ConfigurationFactory;
import liquibase.ext.hibernate.database.HibernateDatabase;
import liquibase.ext.hibernate.database.connection.HibernateConnection;
import org.hibernate.cfg.Configuration;
import org.hibernate.jpa.HibernatePersistenceProvider;
import org.hibernate.jpa.boot.internal.EntityManagerFactoryBuilderImpl;
import org.hibernate.jpa.boot.spi.EntityManagerFactoryBuilder;
import org.hibernate.service.ServiceRegistry;

public class HibernateEjb3Database
extends HibernateDatabase {
    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        return conn.getURL().startsWith("hibernate:ejb3:");
    }

    @Override
    protected Configuration buildConfiguration(HibernateConnection connection) throws DatabaseException {
        if (this.isCustomFactoryClass(connection.getPath())) {
            return this.buildConfigurationFromFactory(connection);
        }
        return this.buildConfigurationfromFile(connection);
    }

    protected Configuration buildConfigurationfromFile(HibernateConnection connection) {
        MyHibernatePersistenceProvider persistenceProvider = new MyHibernatePersistenceProvider();
        EntityManagerFactoryBuilderImpl builder = (EntityManagerFactoryBuilderImpl)persistenceProvider.getEntityManagerFactoryBuilderOrNull(connection.getPath(), null, null);
        ServiceRegistry serviceRegistry = builder.buildServiceRegistry();
        return builder.buildHibernateConfiguration(serviceRegistry);
    }

    protected Configuration buildConfigurationFromFactory(HibernateConnection connection) throws DatabaseException {
        try {
            return ((CustomEjb3ConfigurationFactory)Class.forName(connection.getPath()).newInstance()).getConfiguration(this, connection);
        }
        catch (InstantiationException e) {
            throw new DatabaseException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new DatabaseException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    protected boolean isCustomFactoryClass(String path) {
        if (path.contains("/")) {
            return false;
        }
        try {
            Class<?> clazz = Class.forName(path);
            return CustomEjb3ConfigurationFactory.class.isAssignableFrom(clazz);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public String getShortName() {
        return "hibernateEjb3";
    }

    protected String getDefaultDatabaseProductName() {
        return "Hibernate EJB3";
    }

    private static class MyHibernatePersistenceProvider
    extends HibernatePersistenceProvider {
        private MyHibernatePersistenceProvider() {
        }

        protected EntityManagerFactoryBuilder getEntityManagerFactoryBuilderOrNull(String persistenceUnitName, Map properties, ClassLoader providedClassLoader) {
            return super.getEntityManagerFactoryBuilderOrNull(persistenceUnitName, properties, providedClassLoader);
        }
    }
}

