/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.hibernate.snapshot;

import liquibase.exception.DatabaseException;
import liquibase.ext.hibernate.snapshot.HibernateSnapshotGenerator;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Index;
import liquibase.structure.core.PrimaryKey;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;

public class PrimaryKeySnapshotGenerator
extends HibernateSnapshotGenerator {
    public PrimaryKeySnapshotGenerator() {
        super(PrimaryKey.class, new Class[]{liquibase.structure.core.Table.class});
    }

    @Override
    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        return example;
    }

    @Override
    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        liquibase.structure.core.Table table;
        Table hibernateTable;
        org.hibernate.mapping.PrimaryKey hibernatePrimaryKey;
        if (!snapshot.getSnapshotControl().shouldInclude(PrimaryKey.class)) {
            return;
        }
        if (foundObject instanceof liquibase.structure.core.Table && (hibernatePrimaryKey = (hibernateTable = this.findHibernateTable((DatabaseObject)(table = (liquibase.structure.core.Table)foundObject), snapshot)).getPrimaryKey()) != null) {
            PrimaryKey pk = new PrimaryKey();
            pk.setName(hibernatePrimaryKey.getName());
            pk.setTable(table);
            for (Object hibernateColumn : hibernatePrimaryKey.getColumns()) {
                pk.getColumnNamesAsList().add(((Column)hibernateColumn).getName());
            }
            LOG.info("Found primary key " + pk.getName());
            table.setPrimaryKey(pk);
            Index index = new Index();
            index.setName("IX_" + pk.getName());
            index.setTable(table);
            index.setColumns(pk.getColumnNames());
            index.setUnique(Boolean.valueOf(true));
            pk.setBackingIndex(index);
            table.getIndexes().add(index);
        }
    }
}

