/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.hibernate.database;

import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.DatabaseConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.ext.hibernate.database.HibernateGenericDialect;
import liquibase.ext.hibernate.database.connection.HibernateConnection;
import liquibase.ext.hibernate.database.connection.HibernateDriver;
import liquibase.logging.LogFactory;
import liquibase.logging.Logger;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MySQLDialect;

public abstract class HibernateDatabase
extends AbstractJdbcDatabase {
    protected static final Logger LOG = LogFactory.getLogger((String)"liquibase-hibernate");
    private Configuration configuration;
    private Dialect dialect;
    private boolean indexesForForeignKeys = false;
    public static final String DEFAULT_SCHEMA = "HIBERNATE";

    public HibernateDatabase() {
        this.setDefaultCatalogName(DEFAULT_SCHEMA);
        this.setDefaultSchemaName(DEFAULT_SCHEMA);
    }

    public void setConnection(DatabaseConnection conn) {
        super.setConnection(conn);
        try {
            LOG.info("Reading hibernate configuration " + this.getConnection().getURL());
            this.configuration = this.buildConfiguration((HibernateConnection)((JdbcConnection)conn).getUnderlyingConnection());
            this.configuration.buildMappings();
            this.dialect = this.configureDialect();
            this.afterSetup();
        }
        catch (DatabaseException e) {
            throw new UnexpectedLiquibaseException((Throwable)e);
        }
    }

    protected Dialect configureDialect() throws DatabaseException {
        Dialect dialect;
        String dialectString = this.configuration.getProperty("hibernate.dialect");
        if (dialectString != null) {
            try {
                dialect = (Dialect)Class.forName(dialectString).newInstance();
                LOG.info("Using dialect " + dialectString);
            }
            catch (Exception e) {
                throw new DatabaseException((Throwable)e);
            }
        } else {
            LOG.info("Could not determine hibernate dialect, using HibernateGenericDialect");
            dialect = new HibernateGenericDialect();
        }
        return dialect;
    }

    protected void configureNamingStrategy(Configuration configuration, HibernateConnection connection) {
        String namingStrategy = connection.getProperties().getProperty("hibernate.namingStrategy");
        if (namingStrategy == null) {
            namingStrategy = connection.getProperties().getProperty("hibernate.ejb.naming_strategy");
        }
        if (namingStrategy != null) {
            try {
                configuration.setNamingStrategy((NamingStrategy)Class.forName(namingStrategy).newInstance());
            }
            catch (InstantiationException e) {
                throw new IllegalStateException("Failed to instantiate naming strategy", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Couldn't access naming strategy", e);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Failed to find naming strategy", e);
            }
        }
    }

    protected void afterSetup() {
        if (this.dialect instanceof MySQLDialect) {
            this.indexesForForeignKeys = true;
        }
    }

    protected abstract Configuration buildConfiguration(HibernateConnection var1) throws DatabaseException;

    public boolean requiresPassword() {
        return false;
    }

    public boolean requiresUsername() {
        return false;
    }

    public String getDefaultDriver(String url) {
        if (url.startsWith("hibernate")) {
            return HibernateDriver.class.getName();
        }
        return null;
    }

    public int getPriority() {
        return 1;
    }

    public boolean createsIndexesForForeignKeys() {
        return this.indexesForForeignKeys;
    }

    public Integer getDefaultPort() {
        return 0;
    }

    public boolean supportsInitiallyDeferrableColumns() {
        return false;
    }

    public boolean supportsTablespaces() {
        return false;
    }

    public Configuration getConfiguration() throws DatabaseException {
        return this.configuration;
    }

    public Dialect getDialect() throws DatabaseException {
        return this.dialect;
    }

    protected String getConnectionCatalogName() throws DatabaseException {
        return this.getDefaultCatalogName();
    }

    protected String getConnectionSchemaName() {
        return this.getDefaultSchemaName();
    }

    public String getDefaultSchemaName() {
        return DEFAULT_SCHEMA;
    }

    public String getDefaultCatalogName() {
        return DEFAULT_SCHEMA;
    }

    public boolean isSafeToRunUpdate() throws DatabaseException {
        return true;
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public boolean supportsSchemas() {
        return true;
    }

    public boolean supportsCatalogs() {
        return false;
    }
}

