/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.changelog;

import java.util.Objects;
import liquibase.change.CheckSum;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.RanChangeSet;
import liquibase.util.StringUtils;
import org.bson.Document;

public final class ChangeSetUtils {
    public static Document toDocument(RanChangeSet ranChangeSet) {
        Document document = new Document().append("id", (Object)ranChangeSet.getId()).append("author", (Object)ranChangeSet.getAuthor()).append("fileName", (Object)ranChangeSet.getChangeLog()).append("dateExecuted", (Object)ranChangeSet.getDateExecuted()).append("execType", (Object)ranChangeSet.getExecType().value).append("md5sum", (Object)ranChangeSet.getLastCheckSum().toString()).append("description", (Object)ranChangeSet.getDescription());
        if (Objects.nonNull(ranChangeSet.getOrderExecuted())) {
            document.append("orderExecuted", (Object)ranChangeSet.getOrderExecuted());
        }
        if (StringUtils.isNotEmpty((String)ranChangeSet.getComments())) {
            document.append("comments", (Object)ranChangeSet.getComments());
        }
        if (StringUtils.isNotEmpty((String)ranChangeSet.getTag())) {
            document.append("tag", (Object)ranChangeSet.getTag());
        }
        if (StringUtils.isNotEmpty((String)ranChangeSet.getDeploymentId())) {
            document.append("liquibase", (Object)ranChangeSet.getDeploymentId());
        }
        return document;
    }

    public static RanChangeSet fromDocument(Document document) {
        RanChangeSet ranChangeSet = new RanChangeSet(document.getString((Object)"fileName"), document.getString((Object)"id"), document.getString((Object)"author"), CheckSum.parse((String)document.getString((Object)"md5sum")), document.getDate((Object)"dateExecuted"), document.getString((Object)"tag"), ChangeSet.ExecType.valueOf((String)document.getString((Object)"execType")), document.getString((Object)"description"), document.getString((Object)"comments"), null, null, document.getString((Object)"liquibase"));
        ranChangeSet.setOrderExecuted(document.getInteger((Object)"orderExecuted"));
        return ranChangeSet;
    }

    private ChangeSetUtils() {
    }
}

