/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.changelog;

import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Updates;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import liquibase.changelog.AbstractChangeLogHistoryService;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.RanChangeSet;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.exception.DatabaseHistoryException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.ext.mongodb.changelog.ChangeSetUtils;
import liquibase.ext.mongodb.changelog.CreateChangeLogCollectionStatement;
import liquibase.ext.mongodb.database.MongoLiquibaseDatabase;
import liquibase.ext.mongodb.statement.AbstractMongoStatement;
import liquibase.ext.mongodb.statement.CountCollectionByNameStatement;
import liquibase.ext.mongodb.statement.DropCollectionStatement;
import liquibase.logging.LogService;
import liquibase.logging.LogType;
import liquibase.statement.SqlStatement;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoHistoryService
extends AbstractChangeLogHistoryService {
    private static final String CHECKSUM_FIELD_NAME = "md5sum";
    private static final Bson CLEAR_CHECKSUM_FILTER = Filters.exists((String)"md5sum");
    private static final Bson CLEAR_CHECKSUM_UPDATE = Updates.unset((String)"md5sum");
    private List<RanChangeSet> ranChangeSetList;
    private boolean serviceInitialized;
    private Boolean hasDatabaseChangeLogTable;
    private Integer lastChangeSetSequenceValue;

    public int getPriority() {
        return 5;
    }

    public boolean supports(Database database) {
        return "MongoDB".equals(database.getDatabaseProductName());
    }

    public String getDatabaseChangeLogTableName() {
        return this.getDatabase().getDatabaseChangeLogTableName();
    }

    public boolean canCreateChangeLogTable() {
        return true;
    }

    public Boolean getHasDatabaseChangeLogTable() {
        return this.hasDatabaseChangeLogTable;
    }

    public List<RanChangeSet> getRanChangeSetList() {
        return this.ranChangeSetList;
    }

    public boolean isServiceInitialized() {
        return this.serviceInitialized;
    }

    public void reset() {
        this.ranChangeSetList = null;
        this.serviceInitialized = false;
        this.hasDatabaseChangeLogTable = null;
    }

    public boolean hasDatabaseChangeLogTable() {
        if (this.hasDatabaseChangeLogTable == null) {
            try {
                Executor executor = ExecutorService.getInstance().getExecutor(this.getDatabase());
                this.hasDatabaseChangeLogTable = executor.queryForLong((SqlStatement)new CountCollectionByNameStatement(this.getDatabase().getDatabaseChangeLogTableName())) == 1L;
            }
            catch (LiquibaseException e) {
                throw new UnexpectedLiquibaseException((Throwable)e);
            }
        }
        return this.hasDatabaseChangeLogTable;
    }

    public void init() throws DatabaseException {
        if (this.serviceInitialized) {
            return;
        }
        Executor executor = ExecutorService.getInstance().getExecutor(this.getDatabase());
        boolean createdTable = this.hasDatabaseChangeLogTable();
        if (!createdTable) {
            executor.comment("Create Database Change Log Collection");
            CreateChangeLogCollectionStatement createChangeLogCollectionStatement = new CreateChangeLogCollectionStatement(this.getDatabase().getDatabaseChangeLogTableName());
            LogService.getLog(((Object)((Object)this)).getClass()).info(LogType.LOG, "Creating database history collection with name: " + this.getDatabase().getLiquibaseCatalogName() + "." + this.getDatabase().getDatabaseChangeLogTableName());
            executor.execute((SqlStatement)createChangeLogCollectionStatement);
            LogService.getLog(((Object)((Object)this)).getClass()).info(LogType.LOG, "Created database history collection : " + ((AbstractMongoStatement)createChangeLogCollectionStatement).toJs());
        }
        this.serviceInitialized = true;
    }

    public List<RanChangeSet> getRanChangeSets() {
        if (this.ranChangeSetList == null) {
            Document sort = new Document().append("dateExecuted", (Object)1).append("orderExecuted", (Object)1);
            ArrayList ranChangeSets = new ArrayList();
            ((MongoLiquibaseDatabase)this.getDatabase()).getConnection().getDb().getCollection(this.getDatabaseChangeLogTableName()).find().sort((Bson)sort).into(ranChangeSets);
            this.ranChangeSetList = ranChangeSets.stream().map(ChangeSetUtils::fromDocument).collect(Collectors.toList());
        }
        return Collections.unmodifiableList(this.ranChangeSetList);
    }

    protected void replaceChecksum(ChangeSet changeSet) throws DatabaseException {
        Document filter = new Document().append("fileName", (Object)changeSet.getFilePath()).append("id", (Object)changeSet.getId()).append("author", (Object)changeSet.getAuthor());
        Bson update = Updates.set((String)CHECKSUM_FIELD_NAME, (Object)changeSet.generateCheckSum().toString());
        ((MongoLiquibaseDatabase)this.getDatabase()).getConnection().getDb().getCollection(this.getDatabaseChangeLogTableName()).updateOne((Bson)filter, update);
        ExecutorService.getInstance().getExecutor(this.getDatabase()).comment(String.format("Replace checksum executed. Changeset: [filename: %s, id: %s, author: %s]", changeSet.getFilePath(), changeSet.getId(), changeSet.getAuthor()));
        this.reset();
    }

    public RanChangeSet getRanChangeSet(ChangeSet changeSet) throws DatabaseException, DatabaseHistoryException {
        if (!this.hasDatabaseChangeLogTable()) {
            return null;
        }
        return super.getRanChangeSet(changeSet);
    }

    public void setExecType(ChangeSet changeSet, ChangeSet.ExecType execType) throws DatabaseException {
        RanChangeSet ranChangeSet = new RanChangeSet(changeSet, execType, null, null);
        if (execType.ranBefore) {
            Document filter = new Document().append("fileName", (Object)changeSet.getFilePath()).append("id", (Object)changeSet.getId()).append("author", (Object)changeSet.getAuthor());
            Document update = new Document().append("execType", (Object)execType.value);
            ((MongoLiquibaseDatabase)this.getDatabase()).getConnection().getDb().getCollection(this.getDatabaseChangeLogTableName()).updateOne((Bson)filter, (Bson)update);
        } else {
            ranChangeSet.setOrderExecuted(Integer.valueOf(this.getNextSequenceValue()));
            ((MongoLiquibaseDatabase)this.getDatabase()).getConnection().getDb().getCollection(this.getDatabaseChangeLogTableName()).insertOne((Object)ChangeSetUtils.toDocument(ranChangeSet));
        }
        if (this.ranChangeSetList != null) {
            this.ranChangeSetList.add(ranChangeSet);
        }
    }

    public void removeFromHistory(ChangeSet changeSet) throws DatabaseException {
        Document filter = new Document().append("fileName", (Object)changeSet.getFilePath()).append("id", (Object)changeSet.getId()).append("author", (Object)changeSet.getAuthor());
        ((MongoLiquibaseDatabase)this.getDatabase()).getConnection().getDb().getCollection(this.getDatabaseChangeLogTableName()).deleteOne((Bson)filter);
        if (this.ranChangeSetList != null) {
            this.ranChangeSetList.remove(new RanChangeSet(changeSet));
        }
    }

    public int getNextSequenceValue() {
        if (this.lastChangeSetSequenceValue == null) {
            this.lastChangeSetSequenceValue = this.getDatabase().getConnection() == null ? Integer.valueOf(0) : Integer.valueOf((int)((MongoLiquibaseDatabase)this.getDatabase()).getConnection().getDb().getCollection(this.getDatabaseChangeLogTableName()).countDocuments());
        }
        this.lastChangeSetSequenceValue = this.lastChangeSetSequenceValue + 1;
        return this.lastChangeSetSequenceValue;
    }

    public void tag(String tagString) throws DatabaseException {
        long totalRows = ((MongoLiquibaseDatabase)this.getDatabase()).getConnection().getDb().getCollection(this.getDatabaseChangeLogTableName()).countDocuments();
        if (totalRows == 0L) {
            ChangeSet emptyChangeSet = new ChangeSet(String.valueOf(new Date().getTime()), "liquibase", false, false, "liquibase-internal", null, null, this.getDatabase().getObjectQuotingStrategy(), null);
            this.setExecType(emptyChangeSet, ChangeSet.ExecType.EXECUTED);
        }
        if (this.ranChangeSetList != null) {
            this.ranChangeSetList.get(this.ranChangeSetList.size() - 1).setTag(tagString);
        }
    }

    public boolean tagExists(String tag) {
        long count = ((MongoLiquibaseDatabase)this.getDatabase()).getConnection().getDb().getCollection(this.getDatabaseChangeLogTableName()).countDocuments((Bson)new Document("tag", (Object)tag));
        return count > 0L;
    }

    public void clearAllCheckSums() throws DatabaseException {
        ((MongoLiquibaseDatabase)this.getDatabase()).getConnection().getDb().getCollection(this.getDatabaseChangeLogTableName()).updateMany(CLEAR_CHECKSUM_FILTER, CLEAR_CHECKSUM_UPDATE);
        ExecutorService.getInstance().getExecutor(this.getDatabase()).comment("Clear all checksums executed");
    }

    public void destroy() {
        try {
            Executor executor = ExecutorService.getInstance().getExecutor(this.getDatabase());
            executor.comment("Dropping Collection Database Change Log: " + this.getDatabaseChangeLogTableName());
            executor.execute((SqlStatement)new DropCollectionStatement(this.getDatabaseChangeLogTableName()));
            this.reset();
        }
        catch (DatabaseException e) {
            throw new UnexpectedLiquibaseException((Throwable)e);
        }
    }
}

