/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.database;

import liquibase.command.CommandResult;
import liquibase.command.core.DropAllCommand;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.ext.mongodb.statement.DropAllCollectionsStatement;
import liquibase.lockservice.LockService;
import liquibase.lockservice.LockServiceFactory;
import liquibase.statement.SqlStatement;

public class DropCollectionsCommand
extends DropAllCommand {
    private static final String COMMAND_NAME = "dropAll";
    private Database database;

    public String getName() {
        return COMMAND_NAME;
    }

    protected CommandResult run() throws Exception {
        LockService lockService = LockServiceFactory.getInstance().getLockService(this.database);
        try {
            lockService.waitForLock();
            Executor executor = ExecutorService.getInstance().getExecutor(this.database);
            executor.execute((SqlStatement)new DropAllCollectionsStatement());
        }
        catch (DatabaseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DatabaseException((Throwable)e);
        }
        finally {
            lockService.releaseLock();
            lockService.destroy();
            this.resetServices();
        }
        return new CommandResult("All objects dropped from " + this.database.getConnection().getConnectionUserName() + "@" + this.database.getConnection().getURL());
    }

    public int getPriority(String commandName) {
        return COMMAND_NAME.equals(commandName) ? 999 : 0;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }
}

