/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.database;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import java.sql.Driver;
import java.util.Objects;
import java.util.Properties;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.exception.DatabaseException;
import org.bson.UuidRepresentation;
import org.bson.codecs.Codec;
import org.bson.codecs.UuidCodec;
import org.bson.codecs.UuidCodecProvider;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.PojoCodecProvider;

public class MongoConnection
implements DatabaseConnection {
    public final String MONGO_CONNECTION_STRING_PATTERN = "%s/%s";
    private final MongoClient con;
    private final MongoDatabase db;
    private final ConnectionString connectionString;

    public MongoConnection(String connectionString) {
        this.connectionString = new ConnectionString(connectionString);
        this.con = MongoClients.create((ConnectionString)this.connectionString);
        this.db = this.con.getDatabase(Objects.requireNonNull(this.connectionString.getDatabase())).withCodecRegistry(MongoConnection.uuidCodecRegistry());
    }

    public static CodecRegistry uuidCodecRegistry() {
        return CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{CodecRegistries.fromCodecs((Codec[])new Codec[]{new UuidCodec(UuidRepresentation.STANDARD)}), MongoClientSettings.getDefaultCodecRegistry()});
    }

    public static CodecRegistry pojoCodecRegistry() {
        return CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{new UuidCodecProvider(UuidRepresentation.STANDARD)}), CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{PojoCodecProvider.builder().automatic(true).build()}), MongoClientSettings.getDefaultCodecRegistry()});
    }

    public void close() throws DatabaseException {
        try {
            this.con.close();
        }
        catch (Exception e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public void commit() throws DatabaseException {
    }

    public boolean getAutoCommit() throws DatabaseException {
        return false;
    }

    public void setAutoCommit(boolean autoCommit) throws DatabaseException {
    }

    public String getCatalog() throws DatabaseException {
        return this.connectionString.getDatabase();
    }

    public String nativeSQL(String sql) throws DatabaseException {
        return null;
    }

    public void rollback() throws DatabaseException {
    }

    public String getDatabaseProductName() throws DatabaseException {
        return "MongoDB";
    }

    public String getDatabaseProductVersion() throws DatabaseException {
        return null;
    }

    public int getDatabaseMajorVersion() throws DatabaseException {
        return 0;
    }

    public int getDatabaseMinorVersion() throws DatabaseException {
        return 0;
    }

    public String getURL() {
        return String.join((CharSequence)",", this.connectionString.getHosts());
    }

    public String getConnectionUserName() {
        return null;
    }

    public boolean isClosed() throws DatabaseException {
        return false;
    }

    public void attached(Database database) {
    }

    public int getPriority() {
        return 0;
    }

    public void open(String url, Driver driverObject, Properties driverProperties) throws DatabaseException {
    }

    public String getMONGO_CONNECTION_STRING_PATTERN() {
        return this.MONGO_CONNECTION_STRING_PATTERN;
    }

    public MongoClient getCon() {
        return this.con;
    }

    public MongoDatabase getDb() {
        return this.db;
    }

    public ConnectionString getConnectionString() {
        return this.connectionString;
    }
}

