/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.executor;

import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Projections;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import liquibase.change.ColumnConfig;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.executor.AbstractExecutor;
import liquibase.ext.mongodb.database.MongoConnection;
import liquibase.ext.mongodb.statement.AbstractMongoDocumentStatement;
import liquibase.ext.mongodb.statement.AbstractMongoStatement;
import liquibase.logging.LogService;
import liquibase.servicelocator.LiquibaseService;
import liquibase.sql.visitor.SqlVisitor;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.SelectFromDatabaseChangeLogLockStatement;
import liquibase.statement.core.UpdateStatement;
import org.bson.Document;

@LiquibaseService
public class MongoExecutor
extends AbstractExecutor {
    public MongoDatabase db;

    public void setDatabase(Database database) {
        super.setDatabase(database);
        this.db = ((MongoConnection)this.database.getConnection()).getDb();
    }

    public <T> T queryForObject(SqlStatement sql, Class<T> requiredType) {
        if (sql instanceof SelectFromDatabaseChangeLogLockStatement) {
            SelectFromDatabaseChangeLogLockStatement statement = (SelectFromDatabaseChangeLogLockStatement)sql;
            List fieldsToSelect = Stream.of(statement.getColumnsToSelect()).map(ColumnConfig::getName).collect(Collectors.toList());
            return (T)this.db.getCollection("databaseChangeLogLock").find().projection(Projections.include(fieldsToSelect)).first();
        }
        return null;
    }

    public <T> T queryForObject(SqlStatement sql, Class<T> requiredType, List<SqlVisitor> sqlVisitors) {
        if (sql instanceof AbstractMongoStatement) {
            return ((AbstractMongoStatement)sql).queryForObject(this.db, requiredType);
        }
        throw new IllegalArgumentException();
    }

    public long queryForLong(SqlStatement sql) {
        if (sql instanceof AbstractMongoStatement) {
            return ((AbstractMongoStatement)sql).queryForLong(this.db);
        }
        throw new IllegalArgumentException();
    }

    public long queryForLong(SqlStatement sql, List<SqlVisitor> sqlVisitors) {
        return 0L;
    }

    public int queryForInt(SqlStatement sql) {
        return 0;
    }

    public int queryForInt(SqlStatement sql, List<SqlVisitor> sqlVisitors) {
        return 0;
    }

    public List<Object> queryForList(SqlStatement sql, Class elementType) throws DatabaseException {
        if (sql instanceof AbstractMongoStatement) {
            return ((AbstractMongoStatement)sql).queryForList(this.db, elementType);
        }
        throw new IllegalArgumentException();
    }

    public List<Object> queryForList(SqlStatement sql, Class elementType, List<SqlVisitor> sqlVisitors) {
        return Collections.emptyList();
    }

    public List<Map<String, ?>> queryForList(SqlStatement sql) {
        return Collections.emptyList();
    }

    public List<Map<String, ?>> queryForList(SqlStatement sql, List<SqlVisitor> sqlVisitors) {
        return Collections.emptyList();
    }

    public void execute(SqlStatement sql) {
        this.execute(sql, Collections.emptyList());
    }

    public void execute(SqlStatement sql, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        if (sql instanceof AbstractMongoStatement) {
            ((AbstractMongoStatement)sql).execute(this.db);
        } else if (MongoExecutor.isClearChecksumStatement(sql)) {
            try {
                ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(this.database).clearAllCheckSums();
            }
            catch (LiquibaseException e) {
                LogService.getLog(((Object)((Object)this)).getClass()).severe("Execution exception ", (Throwable)e);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public int update(SqlStatement sql) {
        if (sql instanceof AbstractMongoStatement) {
            return ((AbstractMongoStatement)sql).update(this.db);
        }
        throw new IllegalArgumentException();
    }

    public int update(SqlStatement sql, List<SqlVisitor> sqlVisitors) {
        return 0;
    }

    public void comment(String message) {
        LogService.getLog(((Object)((Object)this)).getClass()).debug(message);
    }

    public boolean updatesDatabase() {
        return true;
    }

    public <T extends Document> T run(AbstractMongoDocumentStatement<T> sql) {
        return sql.run(this.db);
    }

    private static boolean isClearChecksumStatement(SqlStatement sqlStatement) {
        return sqlStatement instanceof UpdateStatement && ((UpdateStatement)sqlStatement).getNewColumnValues().containsKey("MD5SUM");
    }

    public String getName() {
        return null;
    }

    public int getPriority() {
        return 0;
    }

    public MongoDatabase getDb() {
        return this.db;
    }

    public void setDb(MongoDatabase db) {
        this.db = db;
    }
}

