/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.lockservice;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import liquibase.configuration.GlobalConfiguration;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.exception.LockException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.ext.mongodb.database.MongoLiquibaseDatabase;
import liquibase.ext.mongodb.lockservice.CreateChangelogLockCollectionStatement;
import liquibase.ext.mongodb.lockservice.MongoChangeLogLock;
import liquibase.ext.mongodb.lockservice.ReplaceLockChangeLogStatement;
import liquibase.ext.mongodb.lockservice.SelectLockChangeLogStatement;
import liquibase.ext.mongodb.statement.CountDocumentsInCollectionStatement;
import liquibase.ext.mongodb.statement.DropCollectionStatement;
import liquibase.ext.mongodb.statement.FindAllStatement;
import liquibase.lockservice.DatabaseChangeLogLock;
import liquibase.lockservice.LockService;
import liquibase.logging.LogService;
import liquibase.logging.LogType;
import liquibase.statement.SqlStatement;
import org.bson.Document;

public class MongoLockService
implements LockService {
    private static ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
    protected MongoLiquibaseDatabase database;
    private boolean hasChangeLogLock;
    private Long changeLogLockPollRate;
    private Long changeLogLockRecheckTime;
    private Boolean hasDatabaseChangeLogLockTable;

    public int getPriority() {
        return 5;
    }

    public boolean supports(Database database) {
        return "MongoDB".equals(database.getDatabaseProductName());
    }

    public void setDatabase(Database database) {
        this.database = (MongoLiquibaseDatabase)database;
    }

    public void init() throws DatabaseException {
        if (!this.hasDatabaseChangeLogLockTable()) {
            try {
                Executor executor = ExecutorService.getInstance().getExecutor((Database)this.getDatabase());
                executor.comment("Create Database Lock Collection");
                CreateChangelogLockCollectionStatement createChangeLogLockCollectionStatement = new CreateChangelogLockCollectionStatement(this.getDatabaseChangeLogLockTableName());
                executor.execute((SqlStatement)createChangeLogLockCollectionStatement);
                this.database.commit();
                LogService.getLog(this.getClass()).debug(LogType.LOG, "Created database lock collection: " + createChangeLogLockCollectionStatement.toJs());
            }
            catch (DatabaseException e) {
                if (e.getMessage() != null && e.getMessage().contains("exists")) {
                    LogService.getLog(this.getClass()).debug(LogType.LOG, "Database lock collection already appears to exist due to exception: " + e.getMessage() + ". Continuing on");
                }
                throw e;
            }
            this.hasDatabaseChangeLogLockTable = true;
        }
    }

    public boolean hasChangeLogLock() {
        return this.hasChangeLogLock;
    }

    public void waitForLock() throws LockException {
        boolean locked = false;
        long timeToGiveUp = new Date().getTime() + this.getChangeLogLockWaitTime() * 1000L * 60L;
        while (!locked && new Date().getTime() < timeToGiveUp) {
            locked = this.acquireLock();
            if (locked) continue;
            LogService.getLog(this.getClass()).info(LogType.LOG, "Waiting for changelog lock....");
            try {
                Thread.sleep(this.getChangeLogLockRecheckTime() * 1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (!locked) {
            String lockedBy;
            DatabaseChangeLogLock[] locks = this.listLocks();
            if (locks.length > 0) {
                DatabaseChangeLogLock lock = locks[0];
                lockedBy = lock.getLockedBy() + " since " + DateFormat.getDateTimeInstance(3, 3).format(lock.getLockGranted());
            } else {
                lockedBy = "UNKNOWN";
            }
            throw new LockException("Could not acquire change log lock.  Currently locked by " + lockedBy);
        }
    }

    public boolean acquireLock() throws LockException {
        try {
            Executor executor = ExecutorService.getInstance().getExecutor((Database)this.getDatabase());
            this.database.rollback();
            this.init();
            Optional<Object> lock = Optional.ofNullable(executor.queryForObject((SqlStatement)new SelectLockChangeLogStatement(this.getDatabaseChangeLogLockTableName()), MongoChangeLogLock.class));
            if (lock.isPresent() && ((MongoChangeLogLock)((Object)lock.get())).getLocked().booleanValue()) {
                boolean bl = false;
                return bl;
            }
            executor.comment("Lock Database");
            int rowsUpdated = executor.update((SqlStatement)new ReplaceLockChangeLogStatement(this.getDatabaseChangeLogLockTableName(), true));
            if (rowsUpdated > 1) {
                throw new LockException("Did not update change log lock correctly");
            }
            if (rowsUpdated == 0) {
                boolean bl = false;
                return bl;
            }
            this.database.commit();
            LogService.getLog(this.getClass()).info(LogType.LOG, coreBundle.getString("successfully.acquired.change.log.lock"));
            this.hasChangeLogLock = true;
            this.database.setCanCacheLiquibaseTableInfo(true);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new LockException((Throwable)e);
        }
        finally {
            try {
                this.database.rollback();
            }
            catch (DatabaseException e) {
                LogService.getLog(this.getClass()).severe(LogType.LOG, "Error on acquire change log lock Rollback.", (Throwable)e);
            }
        }
    }

    public void releaseLock() throws LockException {
        try {
            if (this.hasDatabaseChangeLogLockTable()) {
                Executor executor = ExecutorService.getInstance().getExecutor((Database)this.getDatabase());
                executor.comment("Release Database Lock");
                this.database.rollback();
                int rowsUpdated = executor.update((SqlStatement)new ReplaceLockChangeLogStatement(this.getDatabaseChangeLogLockTableName(), false));
                if (rowsUpdated != 1) {
                    throw new LockException("Did not update change log lock correctly.\n\n" + rowsUpdated + " rows were updated instead of the expected 1 row using executor " + executor.getClass().getName() + " there are more than one rows in the table");
                }
                this.database.commit();
            }
        }
        catch (Exception e) {
            throw new LockException((Throwable)e);
        }
        finally {
            try {
                this.database.setCanCacheLiquibaseTableInfo(false);
                LogService.getLog(this.getClass()).info(LogType.LOG, "Successfully released change log lock");
                this.database.rollback();
            }
            catch (DatabaseException e) {
                LogService.getLog(this.getClass()).severe(LogType.LOG, "Error on released change log lock Rollback.", (Throwable)e);
            }
        }
    }

    public DatabaseChangeLogLock[] listLocks() throws LockException {
        try {
            if (!this.hasDatabaseChangeLogLockTable()) {
                return new DatabaseChangeLogLock[0];
            }
            FindAllStatement stmt = new FindAllStatement(this.getDatabaseChangeLogLockTableName());
            Executor executor = ExecutorService.getInstance().getExecutor((Database)this.getDatabase());
            List rows = executor.queryForList((SqlStatement)stmt, Document.class).stream().map(d -> MongoChangeLogLock.from((Document)d)).collect(Collectors.toList());
            ArrayList<DatabaseChangeLogLock> allLocks = new ArrayList<DatabaseChangeLogLock>(rows);
            return allLocks.toArray(new DatabaseChangeLogLock[0]);
        }
        catch (Exception e) {
            throw new LockException((Throwable)e);
        }
    }

    public void forceReleaseLock() throws LockException, DatabaseException {
        this.init();
        this.releaseLock();
    }

    public void reset() {
        this.hasChangeLogLock = false;
        this.hasDatabaseChangeLogLockTable = null;
    }

    public void destroy() {
        try {
            Executor executor = ExecutorService.getInstance().getExecutor((Database)this.getDatabase());
            executor.comment("Dropping Collection Database Change Log Lock: " + this.getDatabaseChangeLogLockTableName());
            executor.execute((SqlStatement)new DropCollectionStatement(this.getDatabaseChangeLogLockTableName()));
            this.hasDatabaseChangeLogLockTable = null;
            this.database.commit();
            this.reset();
        }
        catch (DatabaseException e) {
            throw new UnexpectedLiquibaseException((Throwable)e);
        }
    }

    public String getDatabaseChangeLogLockTableName() {
        return this.database.getDatabaseChangeLogLockTableName();
    }

    private Long getChangeLogLockRecheckTime() {
        if (this.changeLogLockRecheckTime != null) {
            return this.changeLogLockRecheckTime;
        }
        return ((GlobalConfiguration)LiquibaseConfiguration.getInstance().getConfiguration(GlobalConfiguration.class)).getDatabaseChangeLogLockPollRate();
    }

    public void setChangeLogLockRecheckTime(long changeLogLockRecheckTime) {
        this.changeLogLockRecheckTime = changeLogLockRecheckTime;
    }

    private Long getChangeLogLockWaitTime() {
        if (this.changeLogLockPollRate != null) {
            return this.changeLogLockPollRate;
        }
        return ((GlobalConfiguration)LiquibaseConfiguration.getInstance().getConfiguration(GlobalConfiguration.class)).getDatabaseChangeLogLockWaitTime();
    }

    public void setChangeLogLockWaitTime(long changeLogLockWaitTime) {
        this.changeLogLockPollRate = changeLogLockWaitTime;
    }

    private boolean hasDatabaseChangeLogLockTable() throws DatabaseException {
        if (this.hasDatabaseChangeLogLockTable == null) {
            try {
                Executor executor = ExecutorService.getInstance().getExecutor((Database)this.getDatabase());
                this.hasDatabaseChangeLogLockTable = executor.queryForLong((SqlStatement)new CountDocumentsInCollectionStatement(this.getDatabase().getDatabaseChangeLogLockTableName())) == 1L;
            }
            catch (Exception e) {
                throw new DatabaseException((Throwable)e);
            }
        }
        return this.hasDatabaseChangeLogLockTable;
    }

    public MongoLiquibaseDatabase getDatabase() {
        return this.database;
    }

    public Long getChangeLogLockPollRate() {
        return this.changeLogLockPollRate;
    }

    public Boolean getHasDatabaseChangeLogLockTable() {
        return this.hasDatabaseChangeLogLockTable;
    }
}

