/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.lockservice;

import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.ReturnDocument;
import java.util.Date;
import java.util.Optional;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.ext.mongodb.lockservice.MongoChangeLogLock;
import liquibase.ext.mongodb.statement.AbstractMongoStatement;
import liquibase.util.NetUtil;
import org.bson.Document;

public class ReplaceLockChangeLogStatement
extends AbstractMongoStatement {
    public static final String COMMAND_NAME = "update";
    protected static final String HOST_NAME;
    protected static final String HOST_ADDRESS;
    protected static final String HOST_DESCRIPTION;
    private String collectionName;
    private boolean locked;

    @Override
    public String toJs() {
        return "db." + this.collectionName + "." + COMMAND_NAME + "();";
    }

    @Override
    public int update(MongoDatabase db) {
        MongoChangeLogLock entry = new MongoChangeLogLock(1, new Date(), HOST_NAME + HOST_DESCRIPTION + " (" + HOST_ADDRESS + ")", true);
        Document inputDocument = entry.toDocument();
        inputDocument.put("locked", (Object)this.locked);
        Optional<Object> changeLogLock = Optional.ofNullable(db.getCollection(this.collectionName).findOneAndReplace(Filters.eq((String)"_id", (Object)entry.getId()), (Object)inputDocument, new FindOneAndReplaceOptions().upsert(true).returnDocument(ReturnDocument.AFTER)));
        return changeLogLock.map(e -> 1).orElse(0);
    }

    public ReplaceLockChangeLogStatement(String collectionName, boolean locked) {
        this.collectionName = collectionName;
        this.locked = locked;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    static {
        HOST_DESCRIPTION = System.getProperty("liquibase.hostDescription") == null ? "" : "#" + System.getProperty("liquibase.hostDescription");
        try {
            HOST_NAME = NetUtil.getLocalHostName();
            HOST_ADDRESS = NetUtil.getLocalHostAddress();
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException((Throwable)e);
        }
    }
}

