/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.statement;

import com.mongodb.client.MongoDatabase;
import liquibase.ext.mongodb.statement.BsonUtils;
import liquibase.ext.mongodb.statement.RunCommandStatement;
import org.bson.Document;
import org.bson.conversions.Bson;

public class AdminCommandStatement
extends RunCommandStatement {
    public static final String COMMAND_NAME = "adminCommand";

    public AdminCommandStatement(String command) {
        this(BsonUtils.orEmptyDocument(command));
    }

    public AdminCommandStatement(Document command) {
        super(command);
    }

    @Override
    public String toJs() {
        return "db.adminCommand(" + this.command.toJson() + ");";
    }

    @Override
    public Document run(MongoDatabase db) {
        return db.runCommand((Bson)this.command);
    }

    @Override
    public String toString() {
        return this.toJs();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdminCommandStatement)) {
            return false;
        }
        AdminCommandStatement other = (AdminCommandStatement)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AdminCommandStatement;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

