/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.statement;

import com.mongodb.DBRefCodecProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import liquibase.util.StringUtils;
import org.bson.Document;
import org.bson.UuidRepresentation;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.Decoder;
import org.bson.codecs.DocumentCodec;
import org.bson.codecs.DocumentCodecProvider;
import org.bson.codecs.UuidCodecProvider;
import org.bson.codecs.ValueCodecProvider;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;

public final class BsonUtils {
    public static final DocumentCodec DOCUMENT_CODEC = new DocumentCodec(CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{new UuidCodecProvider(UuidRepresentation.JAVA_LEGACY), new ValueCodecProvider(), new BsonValueCodecProvider(), new DocumentCodecProvider(), new DBRefCodecProvider()}));

    public static Document orEmptyDocument(String json) {
        return Optional.ofNullable(StringUtils.trimToNull((String)json)).map(s -> Document.parse((String)s, (Decoder)DOCUMENT_CODEC)).orElseGet(Document::new);
    }

    public static List<Document> orEmptyList(String json) {
        return Optional.ofNullable(StringUtils.trimToNull((String)json)).map(jn -> "{ items: " + jn + "}").map(s -> Document.parse((String)s, (Decoder)DOCUMENT_CODEC)).map(d -> d.getList((Object)"items", Document.class, new ArrayList())).orElseGet(ArrayList::new);
    }

    private BsonUtils() {
    }
}

