/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.statement;

import com.mongodb.client.MongoDatabase;
import java.util.stream.StreamSupport;
import liquibase.ext.mongodb.statement.AbstractMongoStatement;

public class CountCollectionByNameStatement
extends AbstractMongoStatement {
    public static final String COMMAND_NAME = "listCollectionNames";
    private final String collectionName;

    @Override
    public String toJs() {
        return "db.listCollectionNames(" + this.collectionName + ");";
    }

    @Override
    public long queryForLong(MongoDatabase db) {
        return StreamSupport.stream(db.listCollectionNames().spliterator(), false).filter(s -> s.equals(this.collectionName)).count();
    }

    public String toString() {
        return this.toJs();
    }

    public CountCollectionByNameStatement(String collectionName) {
        this.collectionName = collectionName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CountCollectionByNameStatement)) {
            return false;
        }
        CountCollectionByNameStatement other = (CountCollectionByNameStatement)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$collectionName = this.getCollectionName();
        String other$collectionName = other.getCollectionName();
        return !(this$collectionName == null ? other$collectionName != null : !this$collectionName.equals(other$collectionName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CountCollectionByNameStatement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $collectionName = this.getCollectionName();
        result = result * 59 + ($collectionName == null ? 43 : $collectionName.hashCode());
        return result;
    }
}

