/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.statement;

import com.mongodb.client.MongoDatabase;
import liquibase.ext.mongodb.statement.AbstractMongoStatement;

public class CountDocumentsInCollectionStatement
extends AbstractMongoStatement {
    public static final String COMMAND_NAME = "countDocumentsInCollection";
    private final String collectionName;

    @Override
    public String toJs() {
        return "db.countDocumentsInCollection(" + this.collectionName + ");";
    }

    @Override
    public long queryForLong(MongoDatabase db) {
        return db.getCollection(this.collectionName).countDocuments();
    }

    public String toString() {
        return this.toJs();
    }

    public CountDocumentsInCollectionStatement(String collectionName) {
        this.collectionName = collectionName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CountDocumentsInCollectionStatement)) {
            return false;
        }
        CountDocumentsInCollectionStatement other = (CountDocumentsInCollectionStatement)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$collectionName = this.getCollectionName();
        String other$collectionName = other.getCollectionName();
        return !(this$collectionName == null ? other$collectionName != null : !this$collectionName.equals(other$collectionName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CountDocumentsInCollectionStatement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $collectionName = this.getCollectionName();
        result = result * 59 + ($collectionName == null ? 43 : $collectionName.hashCode());
        return result;
    }
}

